/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.client;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.rewrite.render.armor.AzArmorRendererRegistry;
import net.berserker_rpg.client.armor.CustomArmorRenderer;
import net.berserker_rpg.client.effect.RageParticles;
import net.berserker_rpg.client.effect.RageRenderer;
import net.berserker_rpg.client.particle.Particles;
import net.berserker_rpg.client.particle.SmallThunderParticle;
import net.berserker_rpg.effect.BerserkerEffects;
import net.berserker_rpg.item.armor.Armors;
import net.berserker_rpg.spell.BerserkerSpells;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_657;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.client.gui.SpellTooltip;

@Environment(value=EnvType.CLIENT)
public class BerserkerClient
implements ClientModInitializer {
    public void onInitializeClient() {
        for (BerserkerSpells.Entry entry : BerserkerSpells.entries) {
            if (entry.mutator() == null) continue;
            SpellTooltip.addDescriptionMutator((class_2960)entry.id(), (SpellTooltip.DescriptionMutator)entry.mutator());
        }
        CustomModels.registerModelIds(List.of(RageRenderer.modelIdRage));
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.RAGE_PAR, class_657.class_3939::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.SMALL_THUNDER, SmallThunderParticle.Factory::new);
        BerserkerClient.registerArmorRenderer(Armors.wildlingArmorSet, CustomArmorRenderer::wildling_armor);
        BerserkerClient.registerArmorRenderer(Armors.northlingArmorSet, CustomArmorRenderer::northling_armor);
        BerserkerClient.registerArmorRenderer(Armors.netheriteNorthlingArmorSet, CustomArmorRenderer::netherite_northling_armor);
        CustomParticleStatusEffect.register((class_1291)BerserkerEffects.RAGE.effect, (CustomParticleStatusEffect.Spawner)new RageParticles(1));
        CustomModelStatusEffect.register((class_1291)BerserkerEffects.RAGE.effect, (CustomModelStatusEffect.Renderer)new RageRenderer());
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (class_1792)set.head, (class_1792[])new class_1792[]{set.chest, set.legs, set.feet});
    }
}

