/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.spell;

import java.util.ArrayList;
import java.util.List;
import net.berserker_rpg.effect.BerserkerEffects;
import net.berserker_rpg.sounds.BerserkerSounds;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.util.TriState;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.internals.target.SpellTarget;
import org.jetbrains.annotations.Nullable;

public class BerserkerSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Entry improved_bloody_strike = BerserkerSpells.add(BerserkerSpells.improved_bloody_strike());
    public static Entry carve_melee = BerserkerSpells.add(BerserkerSpells.carve_melee());
    public static final Entry wild_rage = BerserkerSpells.add(BerserkerSpells.wild_rage());
    public static final Entry blood_reckoning = BerserkerSpells.add(BerserkerSpells.blood_reckoning());
    public static final Entry bloody_strike = BerserkerSpells.add(BerserkerSpells.bloody_strike());
    public static final Entry outrage = BerserkerSpells.add(BerserkerSpells.outrage());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell.Impact damageImpact(float coefficient, float knockback) {
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = coefficient;
        damage.action.damage.knockback = knockback;
        return damage;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static Spell.Impact createEffectImpact(class_2960 effectId, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectId.toString();
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static Spell modifierSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 1;
        spell.type = Spell.Type.MODIFIER;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, true);
        spell.tooltip.description.color = class_124.field_1080.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.tooltip.name.show_in_compact = false;
        spell.tooltip.name.show_in_details = false;
        spell.tooltip.show_header = false;
        return spell;
    }

    private static Spell.Impact.TargetModifier createImpactModifier(String entityType) {
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_type = entityType;
        Spell.Impact.TargetModifier modifier = new Spell.Impact.TargetModifier();
        modifier.conditions = List.of(condition);
        return modifier;
    }

    private static void bleedingDeny(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = BerserkerSpells.createImpactModifier("#more_rpg_classes:bleeding_immune");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 8;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        return spell;
    }

    private static Entry improved_bloody_strike() {
        class_2960 id = class_2960.method_60655((String)"berserker_rpg", (String)"improved_bloody_strike");
        String title = "Improved Bloody Strike";
        String description = "Increases power multiplier of Bloody Strike by {power_multiplier}";
        Spell spell = BerserkerSpells.modifierSpellBase();
        spell.school = MoreSpellSchools.RAGE_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "berserker_rpg:bloody_strike";
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.power_multiplier = 0.1f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry carve_melee() {
        class_2960 id = class_2960.method_60655((String)"berserker_rpg", (String)"carve");
        String title = "Carve";
        String description = "On melee hit: {trigger_chance} chance to stack armor reduction by {bonus2} and increasing incoming damage by {bonus} for {effect_amplifier_cap} times.";
        Spell spell = BerserkerSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Effects.Entry debuffEffect = BerserkerEffects.CARVE;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = (AttributeModifier)debuffEffect.config().attributes().get(1);
            AttributeModifier modifier2 = (AttributeModifier)debuffEffect.config().attributes().get(0);
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            String bonus2 = SpellTooltip.bonus((float)modifier2.value, (class_1322.class_1323)modifier2.operation);
            return args.description().replace("{bonus}", bonus).replace("{bonus2}", bonus2);
        };
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.equipment_condition = class_1304.field_6173;
        trigger.chance = 0.2f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact debuff = BerserkerSpells.createEffectImpact(debuffEffect.id, 5.0f);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        debuff.action.status_effect.show_particles = false;
        debuff.action.status_effect.amplifier = 1;
        debuff.action.status_effect.amplifier_cap = 5;
        debuff.action.status_effect.duration = 8.0f;
        debuff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SKULL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.2f, 0.25f).color(Color.RAGE.toRGBA())};
        debuff.sound = new Sound(BerserkerSounds.CARVE.id().toString());
        spell.impacts = List.of(debuff);
        BerserkerSpells.configureCooldown(spell, 3.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry wild_rage() {
        class_2960 id = class_2960.method_60655((String)"berserker_rpg", (String)"wild_rage");
        String title = "Wild Rage";
        String description = "Enter a wild rage, increases rage by {bonus} and attack speed by {bonus2}, stacking up to {effect_amplifier_cap} times.";
        Effects.Entry effect = BerserkerEffects.RAGE;
        Spell spell = SpellBuilder.createSpellActive();
        spell.range = 0.0f;
        spell.tier = 1;
        spell.school = MoreSpellSchools.RAGE_MELEE;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = (AttributeModifier)effect.config().attributes().get(1);
            AttributeModifier modifier2 = (AttributeModifier)effect.config().attributes().get(0);
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            String bonus2 = SpellTooltip.bonus((float)modifier2.value, (class_1322.class_1323)modifier2.operation);
            return args.description().replace("{bonus}", bonus).replace("{bonus2}", bonus2);
        };
        spell.release.animation = "more_rpg_classes:two_handed_roar";
        spell.release.sound = new Sound(BerserkerSounds.WILD_RAGE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("minecraft:angry_villager", ParticleBatch.Shape.PIPE, ParticleBatch.Origin.CENTER, 2.0f, 0.01f, 0.1f).preSpawnTravel(7.0f), new ParticleBatch("berserker_rpg:rage_particle", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 4.0f, 0.01f, 0.2f).preSpawnTravel(7.0f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 20.0f, 0.2f, 0.25f).extent(-0.2f).color(Color.RAGE.toRGBA())};
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashMeleeTrigger = new Spell.Trigger();
        stashMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        stashMeleeTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.deliver.stash_effect.triggers = List.of(stashMeleeTrigger);
        Spell.Impact buff = BerserkerSpells.createEffectImpact(effect.id, 10.0f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 9;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        BerserkerSpells.configureCooldown(spell, 15.0f);
        spell.cost.exhaust = 0.2f;
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry blood_reckoning() {
        class_2960 id = class_2960.method_60655((String)"berserker_rpg", (String)"blood_reckoning");
        String title = "";
        String description = "";
        Spell spell = SpellBuilder.createSpellActive();
        spell.range = 0.0f;
        spell.tier = 2;
        spell.school = MoreSpellSchools.RAGE_MELEE;
        spell.release.animation = "more_rpg_classes:two_handed_roar";
        spell.release.sound = new Sound(BerserkerSounds.BLOOD_RECKONING.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("berserker_rpg:rage_particle", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 4.0f, 0.01f, 0.2f).preSpawnTravel(7.0f), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.2f, 0.4f).color(Color.RAGE.toRGBA()).extent(3.0f), new ParticleBatch(SpellEngineParticles.dripping_blood.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, 15.0f, 0.1f, 0.5f)};
        spell.target.type = Spell.Target.Type.CASTER;
        Spell.Impact custom = new Spell.Impact();
        custom.action = new Spell.Impact.Action();
        custom.action.custom = new Spell.Impact.Action.Custom();
        custom.action.type = Spell.Impact.Action.Type.CUSTOM;
        custom.action.custom.intent = SpellTarget.Intent.HELPFUL;
        custom.action.custom.handler = "berserker_rpg:blood_reckoning";
        spell.impacts = List.of(custom);
        spell.cost.exhaust = 0.3f;
        BerserkerSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry bloody_strike() {
        class_2960 id = class_2960.method_60655((String)"berserker_rpg", (String)"bloody_strike");
        String title = "";
        String description = "";
        Effects.Entry effect = BerserkerEffects.BLOOD_SACRIFICE;
        MRPGCEffects.Entry debuffEffect = MRPGCEffects.BLEEDING;
        Spell spell = SpellBuilder.createSpellActive();
        spell.range = 0.5f;
        spell.range_mechanic = Spell.RangeMechanic.MELEE;
        spell.tier = 3;
        spell.school = MoreSpellSchools.RAGE_MELEE;
        spell.release.animation = "berserker_rpg:berserker_axe_both";
        Spell.Impact buff = BerserkerSpells.createEffectImpact(effect.id, 15.0f);
        buff.action.apply_to_caster = true;
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        buff.action.status_effect.show_particles = false;
        buff.action.status_effect.amplifier_power_multiplier = 0.5f;
        buff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f).extent(0.2f).color(Color.RAGE.toRGBA())};
        Spell.Impact debuff = BerserkerSpells.createEffectImpact(debuffEffect.id, 5.0f);
        BerserkerSpells.bleedingDeny(debuff);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        debuff.action.status_effect.show_particles = false;
        debuff.action.status_effect.amplifier = 1;
        debuff.action.status_effect.amplifier_cap = 5;
        debuff.action.status_effect.amplifier_cap_power_multiplier = 0.2f;
        debuff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.dripping_blood.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.05f, 0.3f), new ParticleBatch("more_rpg_classes:blood_drop", ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, 10.0f, 0.2f, 0.4f)};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 0.5f;
        spell.target.area.angle_degrees = 45.0f;
        Spell.Impact damage = BerserkerSpells.damageImpact(0.65f, 1.0f);
        damage.sound = new Sound(BerserkerSounds.BLOODY_STRIKE.id());
        spell.impacts = List.of(debuff, damage, buff);
        BerserkerSpells.configureCooldown(spell, 13.0f);
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry outrage() {
        class_2960 id = class_2960.method_60655((String)"berserker_rpg", (String)"outrage");
        String title = "Outrage";
        String description = "Clears harmful effects, increases active rage effect duration and increases attack speed and damage by {bonus} for {effect_duration}.";
        Spell spell = SpellBuilder.createSpellActive();
        Effects.Entry effect = BerserkerEffects.OUTRAGE;
        spell.school = MoreSpellSchools.RAGE_MELEE;
        spell.range = 0.0f;
        spell.range_mechanic = Spell.RangeMechanic.MELEE;
        spell.tier = 4;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        spell.release.animation = "more_rpg_classes:two_handed_roar";
        spell.release.sound = new Sound(BerserkerSounds.OUTRAGE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("crimson_spore", ParticleBatch.Shape.PIPE, ParticleBatch.Origin.CENTER, 20.0f, 0.01f, 0.1f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 30.0f, 0.1f, 0.4f).extent(-0.2f).color(Color.RAGE.toRGBA())};
        spell.release.particles_scaled_with_ranged = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_swirl.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(0.25f).followEntity(true).color(Color.RAGE.toRGBA())};
        spell.target.type = Spell.Target.Type.CASTER;
        Spell.Impact buff = BerserkerSpells.createEffectImpact(effect.id, 10.0f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        buff.action.status_effect.amplifier = 0;
        spell.impacts = List.of(buff);
        BerserkerSpells.configureCooldown(spell, 35.0f);
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, mutator);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

