/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.client;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRendererRegistry;
import net.berserker_rpg.client.armor.CustomArmorRenderer;
import net.berserker_rpg.client.effect.RageParticles;
import net.berserker_rpg.client.effect.RageRenderer;
import net.berserker_rpg.client.particle.Particles;
import net.berserker_rpg.client.particle.SmallThunderParticle;
import net.berserker_rpg.effect.BerserkerEffects;
import net.berserker_rpg.item.armor.Armors;
import net.berserker_rpg.spell.BerserkerSpells;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.client.gui.SpellTooltip;

public class BerserkerClient {
    public static void init() {
        for (BerserkerSpells.Entry entry : BerserkerSpells.entries) {
            if (entry.mutator() == null) continue;
            SpellTooltip.addDescriptionMutator((ResourceLocation)entry.id(), (SpellTooltip.DescriptionMutator)entry.mutator());
        }
        CustomModels.registerModelIds(List.of(RageRenderer.modelIdRage));
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.RAGE_PAR, CritParticle.Provider::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.SMALL_THUNDER, SmallThunderParticle.Factory::new);
        BerserkerClient.registerArmorRenderer(Armors.wildlingArmorSet, CustomArmorRenderer::wildling_armor);
        BerserkerClient.registerArmorRenderer(Armors.northlingArmorSet, CustomArmorRenderer::northling_armor);
        BerserkerClient.registerArmorRenderer(Armors.netheriteNorthlingArmorSet, CustomArmorRenderer::netherite_northling_armor);
        CustomParticleStatusEffect.register((MobEffect)BerserkerEffects.RAGE.effect, (CustomParticleStatusEffect.Spawner)new RageParticles(1));
        CustomModelStatusEffect.register((MobEffect)BerserkerEffects.RAGE.effect, (CustomModelStatusEffect.Renderer)new RageRenderer());
    }

    public static void registerParticleAppearances() {
        ParticleFactoryRegistry registry = ParticleFactoryRegistry.getInstance();
        registry.register((ParticleType)Particles.RAGE_PAR, CritParticle.Provider::new);
        registry.register((ParticleType)Particles.SMALL_THUNDER, SmallThunderParticle.Factory::new);
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (Item)set.head, (Item[])new Item[]{set.chest, set.legs, set.feet});
    }
}

