/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.berserker_rpg.effect.BloodSacrificeEffect;
import net.berserker_rpg.effect.CustomStatusEffect;
import net.berserker_rpg.effect.OutrageEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;

public class BerserkerEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static final Effects.Entry RAGE = BerserkerEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"rage"), "", "", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0xF70000), new EffectConfig(List.of(new AttributeModifier(MRPGCEntityAttributes.RAGE_MODIFIER.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.025f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry BLOOD_SACRIFICE = BerserkerEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"blood_sacrifice"), "", "", (MobEffect)new BloodSacrificeEffect(MobEffectCategory.BENEFICIAL, 0xF70000), new EffectConfig(List.of(new AttributeModifier(Attributes.MAX_ABSORPTION.getRegisteredName(), 4.0f, AttributeModifier.Operation.ADD_VALUE)))));
    public static final Effects.Entry OUTRAGE = BerserkerEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"outrage"), "", "", (MobEffect)new OutrageEffect(MobEffectCategory.BENEFICIAL, 0xF70000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry CARVE = BerserkerEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"carve"), "", "", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0xF70000), new EffectConfig(List.of(new AttributeModifier(Attributes.ARMOR.getRegisteredName(), -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id.toString(), -0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        Synchronized.configure((MobEffect)BerserkerEffects.RAGE.effect, (boolean)true);
        Synchronized.configure((MobEffect)BerserkerEffects.BLOOD_SACRIFICE.effect, (boolean)true);
        Synchronized.configure((MobEffect)BerserkerEffects.OUTRAGE.effect, (boolean)true);
        Effects.register(entries, (Map)config.effects);
    }
}

