/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.item.weapons;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.berserker_rpg.BerserkerClassMod;
import net.berserker_rpg.config.TweaksConfig;
import net.berserker_rpg.item.BerserkerGroup;
import net.berserker_rpg.spell.BerserkerSpells;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.SpellSwordItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class WeaponsRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    public static float berserker_axe_attackSpeed = -3.1f;
    public static final Weapon.Entry flint_berserker_axe = WeaponsRegister.berserker_axes("flint_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT})), 7.0f).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry stone_berserker_axe = WeaponsRegister.berserker_axes("stone_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS)), 9.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.01f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry iron_berserker_axe = WeaponsRegister.berserker_axes("iron_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 9.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.02f)).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_berserker_axe = WeaponsRegister.berserker_axes("golden_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 7.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.02f)).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_berserker_axe = WeaponsRegister.berserker_axes("diamond_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 10.5f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.035f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_berserker_axe = WeaponsRegister.berserker_axes("netherite_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 12.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f)).loot(Equipment.LootProperties.of((int)3));
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final String AETHER = "aether";
    private static final String ARSENAL = "arsenal";
    private static final String LNE = "loot_n_explore";
    private static final float lneWeaponSpellPower = 2.0f;
    private static final float lneAxeAttackDamage = 15.0f;
    public static ResourceLocation dragonclaw = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"dragonclaw");
    public static ResourceLocation avalanche = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"avalanche");
    public static ResourceLocation waterbomb = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"waterbomb");
    public static ResourceLocation wither_pulse = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"wither_pulse");

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType weaponType) {
        Weapon.Entry entry = new Weapon.Entry("berserker_rpg", name, material, factory, defaults, weaponType);
        entry.castSpell();
        entries.add(entry);
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry berserker_axes(String name, Weapon.CustomMaterial material, float damage) {
        return WeaponsRegister.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, berserker_axe_attackSpeed), Equipment.WeaponType.DOUBLE_AXE);
    }

    private static Weapon.Entry sword(String name, Weapon.CustomMaterial material, float damage) {
        return WeaponsRegister.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.4f), Equipment.WeaponType.SWORD);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Supplier<Ingredient> repair;
        if (FabricLoader.getInstance().isModLoaded(BETTER_NETHER) || ((TweaksConfig)BerserkerClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.berserker_axes("ruby_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 15.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(BETTER_END) || ((TweaksConfig)BerserkerClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.NETHERITE_INGOT);
            WeaponsRegister.berserker_axes("aeternium_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 15.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(AETHER) || ((TweaksConfig)BerserkerClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.berserker_axes("aether_berserker_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 15.0f).attribute(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).loot(Equipment.LootProperties.of((String)AETHER));
        }
        if (FabricLoader.getInstance().isModLoaded(LNE) || ((TweaksConfig)BerserkerClassMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.berserker_axes((String)"ender_dragon_berserker_axe", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$8(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)15.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)2.0f)).spell((ResourceLocation)WeaponsRegister.dragonclaw).rarity = Rarity.RARE;
            WeaponsRegister.berserker_axes((String)"elder_guardian_berserker_axe", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$9(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)15.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)2.0f)).spell((ResourceLocation)WeaponsRegister.waterbomb).rarity = Rarity.RARE;
            WeaponsRegister.berserker_axes((String)"wither_berserker_axe", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$10(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)15.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.SOUL.id, (float)2.0f)).spell((ResourceLocation)WeaponsRegister.wither_pulse).rarity = Rarity.RARE;
            WeaponsRegister.berserker_axes((String)"glacial_berserker_axe", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$11(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)15.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)2.0f)).spell((ResourceLocation)WeaponsRegister.avalanche).rarity = Rarity.RARE;
        }
        if (FabricLoader.getInstance().isModLoaded(ARSENAL) || ((TweaksConfig)BerserkerClassMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.berserker_axes((String)"unique_berserker_axe_1", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$12(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)15.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.1f)).spell((ResourceLocation)BerserkerSpells.carve_melee.id()).rarity = Rarity.RARE;
            WeaponsRegister.sword((String)"unique_sword_1", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$13(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)8.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f)).spell((ResourceLocation)BerserkerSpells.carve_melee.id()).rarity = Rarity.RARE;
        }
        Weapon.register(configs, entries, BerserkerGroup.BERSERKER_KEY);
    }

    private static /* synthetic */ Ingredient lambda$register$13() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK});
    }

    private static /* synthetic */ Ingredient lambda$register$12() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK});
    }

    private static /* synthetic */ Ingredient lambda$register$11() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE});
    }

    private static /* synthetic */ Ingredient lambda$register$10() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE});
    }

    private static /* synthetic */ Ingredient lambda$register$9() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD});
    }

    private static /* synthetic */ Ingredient lambda$register$8() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD});
    }
}

