/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg;

import net.berserker_rpg.client.particle.Particles;
import net.berserker_rpg.compat.CompatLoadingCheck;
import net.berserker_rpg.config.Default;
import net.berserker_rpg.config.TweaksConfig;
import net.berserker_rpg.effect.BerserkerEffects;
import net.berserker_rpg.item.BerserkerGroup;
import net.berserker_rpg.item.BerserkerItems;
import net.berserker_rpg.item.armor.Armors;
import net.berserker_rpg.item.weapons.WeaponsRegister;
import net.berserker_rpg.sounds.BerserkerSounds;
import net.berserker_rpg.spell.CustomSpellImpacts;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ConfigFile;
import net.tiny_config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerserkerClassMod {
    public static final String MOD_ID = "berserker_rpg";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"berserker_rpg");
    public static ConfigManager<ConfigFile.Equipment> itemConfig = new ConfigManager("equipment_v1", (Object)Default.itemConfig).builder().setDirectory("berserker_rpg").sanitize(true).build();
    public static ConfigManager<ConfigFile.Effects> effectsConfig = new ConfigManager("effects_v4", (Object)new ConfigFile.Effects()).builder().setDirectory("berserker_rpg").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks_v1", (Object)new TweaksConfig()).builder().setDirectory("berserker_rpg").sanitize(true).build();

    public static void init() {
        itemConfig.refresh();
        effectsConfig.refresh();
        tweaksConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)BerserkerClassMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
        CustomSpellImpacts.registerCustomImpacts();
    }

    public static void registerItems() {
        BerserkerItems.registerModItems();
        BerserkerGroup.registerItemGroups();
        BerserkerGroup.BERSERKER = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)Armors.wildlingArmorSet.head.asItem())).title((Component)Component.translatable((String)"itemGroup.berserker_rpg.general")).build();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, BerserkerGroup.BERSERKER_KEY, (Object)BerserkerGroup.BERSERKER);
        WeaponsRegister.register(((ConfigFile.Equipment)BerserkerClassMod.itemConfig.value).weapons);
        Armors.register(((ConfigFile.Equipment)BerserkerClassMod.itemConfig.value).armor_sets);
        if (CompatLoadingCheck.armoryLoadCheck()) {
            FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"berserker_armory_compat"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
        }
        itemConfig.save();
        effectsConfig.save();
    }

    public static void registerSounds() {
        BerserkerSounds.register();
    }

    public static void registerEffects() {
        BerserkerEffects.register((ConfigFile.Effects)BerserkerClassMod.effectsConfig.value);
        effectsConfig.save();
    }

    public static void registerParticles() {
        Particles.register();
    }
}

