/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.client.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.render.LightEmission;

public class RageRenderer
implements CustomModelStatusEffect.Renderer {
    private static final RenderType RENDER_LAYER = CustomLayers.spellEffect((LightEmission)LightEmission.RADIATE, (boolean)false);
    public static final ResourceLocation modelIdRage = ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"effect/rage_model");

    public void renderEffect(int amplifier, LivingEntity livingEntity, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 direction = camera.getPosition().subtract(livingEntity.position()).normalize().scale((double)(livingEntity.getBbWidth() * 0.5f));
        matrixStack.pushPose();
        matrixStack.translate(direction.x, direction.y + (double)(livingEntity.getBbHeight() * 1.1f), direction.z + (double)-0.15f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f + (float)Math.toDegrees(Math.atan2(direction.x, direction.z))));
        matrixStack.mulPose(Axis.XP.rotationDegrees(camera.getXRot()));
        CustomModels.render((RenderType)RENDER_LAYER, (ItemRenderer)itemRenderer, (ResourceLocation)modelIdRage, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumers, (int)light, (int)livingEntity.getId());
        matrixStack.popPose();
    }
}

