/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.effect;

import net.berserker_rpg.BerserkerClassMod;
import net.berserker_rpg.config.TweaksConfig;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BloodSacrificeEffect
extends MobEffect {
    private int healthPerStack = 2;

    public BloodSacrificeEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        return entity.getAbsorptionAmount() > 0.0f || entity.level().isClientSide;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        float modifier = 1.0f;
        double attack_damage = entity.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float actual_health_player = entity.getHealth();
        double amount = (double)modifier * attack_damage;
        float self_damage_calc = (float)(amount * (double)((TweaksConfig)BerserkerClassMod.tweaksConfig.value).bloody_strike_self_damage);
        if (actual_health_player <= 0.5f) {
            entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 300, 2, false, false, true));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 300, 2, false, false, true));
        } else {
            if (self_damage_calc > actual_health_player) {
                entity.setHealth(0.5f);
            } else {
                entity.setHealth(actual_health_player - self_damage_calc);
            }
            entity.setAbsorptionAmount(Math.max(entity.getAbsorptionAmount(), (float)(this.healthPerStack * (1 + amplifier))));
        }
        super.onEffectStarted(entity, amplifier);
    }
}

