/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.item.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.berserker_rpg.compat.CompatLoadingCheck;
import net.berserker_rpg.item.BerserkerGroup;
import net.berserker_rpg.item.armor.NorthlingArmor;
import net.berserker_rpg.item.armor.WildlingArmor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.item.MRPGCItems;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.spell.SpellDataComponents;

public class Armors {
    private static final Supplier<Ingredient> WILDLING_INGREDIENTS = () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER, Items.CHAIN, MRPGCItems.WOLF_FUR});
    private static final Supplier<Ingredient> NORTHLING_INGREDIENTS = () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT, Items.CHAIN, MRPGCItems.POLAR_BEAR_FUR});
    public static ResourceLocation warlord_passive = ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"warlord");
    private static final String CRIT_MOD_ID = "critical_strike";
    private static final ResourceLocation CRIT_CHANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)"chance");
    private static final ResourceLocation CRIT_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)"damage");
    public static final float berserker_atkspeed_T1 = 0.02f;
    public static final float berserker_rage_T1 = 0.025f;
    public static final float berserker_atkspeed_T2 = 0.02f;
    public static final float berserker_rage_T2 = 0.05f;
    public static final float berserker_atkdamage_T2 = 0.04f;
    public static final float berserker_t2_crit_damage = 0.04f;
    public static final float berserker_atkspeed_T3 = 0.02f;
    public static final float berserker_rage_T3 = 0.075f;
    public static final float berserker_atkdamage_T3 = 0.05f;
    public static final float berserker_t3_crit_damage = 0.05f;
    public static final float warlord_atkspeed = 0.025f;
    public static final float warlord_rage = 0.075f;
    public static final float warlord_atkdamage = 0.06f;
    private static final float warlord_crit_damage = 0.08f;
    public static Holder<ArmorMaterial> material_wildling = Armors.material("wildling", 1, 3, 3, 1, 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, WILDLING_INGREDIENTS);
    public static Holder<ArmorMaterial> material_northling = Armors.material("northling", 2, 4, 4, 2, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, NORTHLING_INGREDIENTS);
    public static Holder<ArmorMaterial> material_netherite_northling = Armors.material("netherite_northling", 2, 4, 4, 2, 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_warlord = Armors.material("warlord", 2, 4, 4, 2, 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    public static final Armor.Set wildlingArmorSet = Armors.create(material_wildling, ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"wildling"), 15, WildlingArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.025f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.025f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.025f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.025f)))), 1, null).armorSet();
    public static final Armor.Set northlingArmorSet = Armors.create(material_northling, ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"northling"), 25, NorthlingArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.04f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.04f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.04f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.04f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.04f)))), 2, null).armorSet();
    public static final Armor.Set netheriteNorthlingArmorSet = Armors.create(material_netherite_northling, ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"netherite_northling"), 30, NorthlingArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.02f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f))).addConditional("critical_strike", List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.05f)))), 3, null).armorSet();
    public static Armor.Entry warlordArmorSet;

    private static Armor.ItemSettingsTweaker commonSettings(ResourceLocation equipmentSetId) {
        return Armor.ItemSettingsTweaker.standard(itemSettings -> itemSettings.component(SpellDataComponents.EQUIPMENT_SET, (Object)equipmentSetId).component(DataComponents.RARITY, (Object)Rarity.RARE));
    }

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)name), (Object)material);
    }

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, int tier, Armor.ItemSettingsTweaker settings) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier), (Armor.ItemSettingsTweaker)settings);
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        if (CompatLoadingCheck.armoryLoadCheck()) {
            warlordArmorSet = Armors.create(material_warlord, ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)"warlord"), 40, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.025f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))).addConditional(CRIT_MOD_ID, List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.025f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))).addConditional(CRIT_MOD_ID, List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.025f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))).addConditional(CRIT_MOD_ID, List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_speed")), (float)0.025f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f))).addConditional(CRIT_MOD_ID, List.of(AttributeModifier.multiply((ResourceLocation)CRIT_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"more_rpg_classes:rage_modifier")), (float)0.075f), AttributeModifier.multiply((ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:generic.attack_damage")), (float)0.06f)))), 5, Armors.commonSettings(warlord_passive));
        }
        Armor.register(configs, entries, BerserkerGroup.BERSERKER_KEY);
    }
}

