/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.sounds;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BerserkerSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry WILD_RAGE = BerserkerSounds.add(new Entry("wild_rage"));
    public static final Entry OUTRAGE = BerserkerSounds.add(new Entry("outrage"));
    public static final Entry BLOODY_STRIKE = BerserkerSounds.add(new Entry("bloody_strike"));
    public static final Entry BLOOD_RECKONING = BerserkerSounds.add(new Entry("blood_reckoning"));
    public static final Entry CARVE = BerserkerSounds.add(new Entry("carve"));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        BerserkerSounds.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.playSound((Player)null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"berserker_rpg", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }
    }
}

