/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.model;

import com.google.gson.JsonObject;
import io.github.phantamanta44.libnine.client.model.L9Models;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public abstract class L9CachingModelLoader
implements ICustomModelLoader {
    private final String modelType;
    private final Map<ResourceLocation, IModel> cache = new HashMap<ResourceLocation, IModel>();

    public L9CachingModelLoader(String modelType) {
        this.modelType = modelType;
    }

    public boolean accepts(ResourceLocation loc) {
        return L9Models.isOfType(L9Models.getRealModelLocation(loc), this.modelType);
    }

    public IModel loadModel(ResourceLocation loc) throws Exception {
        IModel model = this.cache.get(loc);
        if (model != null) {
            return model;
        }
        try {
            model = this.parseModel(Objects.requireNonNull(L9Models.resolve((ResourceLocation)L9Models.getRealModelLocation((ResourceLocation)loc))).model);
        }
        catch (Exception e) {
            throw new ModelLoaderRegistry.LoaderException("Failed to load L9 model: " + loc, (Throwable)e);
        }
        this.cache.put(loc, model);
        return model;
    }

    public abstract IModel parseModel(JsonObject var1) throws Exception;

    public void func_110549_a(IResourceManager resourceManager) {
        this.cache.clear();
    }
}

