/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.model;

import com.google.gson.JsonObject;
import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.client.model.ParameterizedItemModelLoader;
import io.github.phantamanta44.libnine.client.model.SumItemModel;
import io.github.phantamanta44.libnine.util.helper.ResourceUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class L9Models {
    private static final ModelCache cache = new ModelCache();

    public static void registerModels() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ParameterizedItemModelLoader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new SumItemModel.Loader());
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)cache);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)cache);
    }

    @Nullable
    public static ModelData resolve(ResourceLocation resource) throws IOException {
        return cache.resolve(resource);
    }

    public static boolean isOfType(ResourceLocation resource, String type) {
        try {
            ModelData data = L9Models.resolve(resource);
            return data != null && data.type.equals(type);
        }
        catch (Exception e) {
            LibNine.LOGGER.warn("Failed to read model data: " + resource, (Throwable)e);
            return false;
        }
    }

    public static ResourceLocation getRealModelLocation(ResourceLocation resource) {
        return new ResourceLocation(resource.func_110624_b(), (resource.func_110623_a().startsWith("models/") ? resource.func_110623_a() : "models/" + resource.func_110623_a()) + ".json");
    }

    private static class ModelCache
    implements ISelectiveResourceReloadListener {
        private final Map<ResourceLocation, Optional<ModelData>> cache = new HashMap<ResourceLocation, Optional<ModelData>>();

        private ModelCache() {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> predicate) {
            if (predicate.test((IResourceType)VanillaResourceType.MODELS)) {
                this.cache.clear();
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onModelsBaked(ModelBakeEvent event) {
            this.cache.clear();
        }

        @Nullable
        public ModelData resolve(ResourceLocation loc) throws IOException {
            Optional<ModelData> dataMaybe = this.cache.get(loc);
            if (dataMaybe != null) {
                return dataMaybe.orElse(null);
            }
            try {
                JsonObject modelDto = ResourceUtils.getAsJson(loc).getAsJsonObject();
                if (modelDto.has("9s")) {
                    ModelData data = new ModelData(modelDto.get("9s").getAsString(), modelDto);
                    this.cache.put(loc, Optional.of(data));
                    return data;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.cache.put(loc, Optional.empty());
            return null;
        }
    }

    public static class ModelData {
        public final String type;
        public final JsonObject model;

        public ModelData(String type, JsonObject model) {
            this.type = type;
            this.model = model;
        }
    }
}

