/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.phantamanta44.libnine.client.model.L9CachingModelLoader;
import io.github.phantamanta44.libnine.util.render.model.BakedQuadList;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class SumItemModel
implements IModel {
    private final List<ModelPart> parts;

    public SumItemModel(List<ModelPart> parts) {
        this.parts = parts;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.parts.stream().map((? super T p) -> p.path).collect(Collectors.toList());
    }

    public Collection<ResourceLocation> getTextures() {
        return this.parts.stream().flatMap(p -> p.model.getTextures().stream()).collect(Collectors.toList());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedSumModel(this.parts.stream().map((? super T p) -> p.model.bake(state, format, bakedTextureGetter)).collect(Collectors.toList()));
    }

    private IModel map(UnaryOperator<IModel> mapper) {
        return new SumItemModel(this.parts.stream().map((? super T p) -> new ModelPart((IModel)mapper.apply(p.model), p.path)).collect(Collectors.toList()));
    }

    public IModel process(ImmutableMap<String, String> customData) {
        return this.map(m -> m.process(customData));
    }

    public IModel smoothLighting(boolean value) {
        return this.map(m -> m.smoothLighting(value));
    }

    public IModel gui3d(boolean value) {
        return this.map(m -> m.gui3d(value));
    }

    public IModel uvlock(boolean value) {
        return this.map(m -> m.uvlock(value));
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return this.map(m -> m.retexture(textures));
    }

    private static class BakedSumModel
    implements IBakedModel {
        private final List<IBakedModel> parts;
        private final boolean ambientOcclusion;
        private final boolean gui3d;
        private final TextureAtlasSprite particleTexture;
        private final SumOverrideCache overrideCache;
        private final BakedQuadList quads = new BakedQuadList();

        private BakedSumModel(List<IBakedModel> parts, SumOverrideCache overrideCache) {
            this.parts = parts;
            this.ambientOcclusion = parts.stream().anyMatch(IBakedModel::func_177555_b);
            this.gui3d = parts.stream().anyMatch(IBakedModel::func_177556_c);
            this.particleTexture = parts.stream().map(IBakedModel::func_177554_e).findFirst().orElseGet(() -> Minecraft.func_71410_x().func_147117_R().func_174944_f());
            this.overrideCache = overrideCache;
            for (IBakedModel part : parts) {
                for (EnumFacing face : WorldUtils.FACES_AND_NULL) {
                    for (BakedQuad quad : part.func_188616_a(null, face, 0L)) {
                        this.quads.addQuad(face, quad);
                    }
                }
            }
        }

        BakedSumModel(List<IBakedModel> parts) {
            this(parts, new SumOverrideCache());
        }

        public ItemOverrideList func_188617_f() {
            return this.overrideCache;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.quads.getQuads(side);
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public boolean func_188618_c() {
            return false;
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public ItemCameraTransforms func_177552_f() {
            return this.parts.get(0).func_177552_f();
        }

        private static class SumOverrideCache
        extends ItemOverrideList {
            private final Cache<NBTTagCompound, BakedSumModel> overrideCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

            public SumOverrideCache() {
                super(Collections.emptyList());
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (!(originalModel instanceof BakedSumModel)) {
                    return originalModel;
                }
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    return originalModel;
                }
                try {
                    return (IBakedModel)this.overrideCache.get((Object)tag, () -> new BakedSumModel(((BakedSumModel)originalModel).parts.stream().map(p -> p.func_188617_f().handleItemState(p, stack, world, entity)).collect(Collectors.toList()), this));
                }
                catch (ExecutionException e) {
                    return originalModel;
                }
            }
        }
    }

    public static class Loader
    extends L9CachingModelLoader {
        public Loader() {
            super("sum");
        }

        @Override
        public IModel parseModel(JsonObject modelDto) throws Exception {
            ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
            for (JsonElement partDto : modelDto.getAsJsonArray("parts")) {
                ResourceLocation partPath = new ResourceLocation(partDto.getAsString());
                parts.add(new ModelPart(ModelLoaderRegistry.getModel((ResourceLocation)partPath), partPath));
            }
            return new SumItemModel(parts);
        }
    }

    public static class ModelPart {
        final IModel model;
        final ResourceLocation path;

        public ModelPart(IModel model, ResourceLocation path) {
            this.model = model;
            this.path = path;
        }
    }
}

