/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.multiblock;

import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockConnectionResult;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockIterator;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockType;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.world.DirectionToggle;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class MultiBlockConnectable<T extends IMultiBlockUnit<T>>
implements Iterable<MultiBlockConnectable<T>>,
ISerializable {
    private final T unit;
    private final MultiBlockType<T> type;
    private final DirectionToggle childDirs = new DirectionToggle();

    public MultiBlockConnectable(T unit, MultiBlockType<T> type) {
        this.unit = unit;
        this.type = type;
    }

    public T getUnit() {
        return this.unit;
    }

    public MultiBlockType<T> getType() {
        return this.type;
    }

    @Nullable
    public abstract MultiBlockCore<T> getCore();

    public abstract void setCore(@Nullable MultiBlockCore<T> var1);

    public Iterable<EnumFacing> getEmittingDirs() {
        return this.childDirs;
    }

    public MultiBlockConnectionResult tryEmit(EnumFacing dir) {
        MultiBlockConnectable<T> adjacent = this.getAdjacent(dir);
        if (adjacent == null) {
            return MultiBlockConnectionResult.NO_ADJACENT;
        }
        MultiBlockCore<T> adjCore = adjacent.getCore();
        if (adjCore == null) {
            this.childDirs.set(dir, true);
            adjacent.setCore(this.getCore());
            return MultiBlockConnectionResult.SUCCESS;
        }
        if (adjCore == this.getCore()) {
            return MultiBlockConnectionResult.EXISTING_CONNECTION;
        }
        return MultiBlockConnectionResult.CONFLICT;
    }

    public void clearEmission() {
        for (EnumFacing dir : this.childDirs) {
            MultiBlockConnectable<T> adjacent = this.getAdjacent(dir);
            if (adjacent == null) continue;
            adjacent.setCore(null);
        }
        this.childDirs.clear();
    }

    public abstract void disconnect();

    @Nullable
    public MultiBlockConnectable<T> getAdjacent(EnumFacing dir) {
        return this.getAtPos(this.getUnit().getWorldPos().getPos().func_177972_a(dir));
    }

    @Nullable
    public MultiBlockConnectable<T> getAtPos(BlockPos pos) {
        T component = this.getType().checkComponent(this.getUnit().getWorldPos().getWorld().func_175625_s(pos));
        return component != null ? component.getMultiBlockConnection() : null;
    }

    @Override
    public Iterator<MultiBlockConnectable<T>> iterator() {
        return new MultiBlockIterator(this);
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        this.childDirs.serBytes(data);
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        this.childDirs.deserBytes(data);
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        NBTTagCompound dirsTag = new NBTTagCompound();
        this.childDirs.serNBT(dirsTag);
        tag.func_74782_a("ChildDirs", (NBTBase)dirsTag);
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        this.childDirs.deserNBT(tag.func_74775_l("ChildDirs"));
    }
}

