/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.collection;

public class BitField {
    private final int length;
    private final byte[] field;

    public BitField(int length) {
        this.length = length;
        this.field = new byte[(int)Math.ceil((float)length / 8.0f)];
    }

    public byte[] getBackingByteArray() {
        return this.field;
    }

    public boolean get(int index) {
        this.checkIndex(index);
        return (this.field[index / 8] & 1 << index % 8) != 0;
    }

    public void set(int index, boolean value) {
        this.checkIndex(index);
        if (value) {
            int n = index / 8;
            this.field[n] = (byte)(this.field[n] | 1 << index % 8);
        } else {
            int n = index / 8;
            this.field[n] = (byte)(this.field[n] & ~(1 << index % 8));
        }
    }

    public void flip(int index) {
        this.checkIndex(index);
        int n = index / 8;
        this.field[n] = (byte)(this.field[n] ^ 1 << index % 8);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index %d outside bitfield length of %d!", index, this.length));
        }
    }
}

