/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TabulatedStringBuffer {
    private final List<StringBuilder> lines;
    private int indentSize = 0;
    private String indent = "";
    private boolean dirty = false;

    public TabulatedStringBuffer(List<String> initial) {
        this.lines = initial.stream().map(StringBuilder::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public TabulatedStringBuffer(String[] initial) {
        this.lines = Arrays.stream(initial).map(StringBuilder::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public TabulatedStringBuffer(String initial) {
        this(initial.split("\n"));
    }

    public TabulatedStringBuffer() {
        this.lines = new ArrayList<StringBuilder>();
    }

    public TabulatedStringBuffer append(String text) {
        if (!text.isEmpty()) {
            String[] newLines = text.split("\n");
            if (this.lines.isEmpty()) {
                this.lines.add(new StringBuilder(this.getIndent()).append(newLines[0]));
            } else {
                this.lines.get(this.lines.size() - 1).append(newLines[0]);
            }
            if (newLines.length > 1) {
                for (int i = 1; i < newLines.length; ++i) {
                    this.appendLine(newLines[i]);
                }
            }
        }
        return this;
    }

    public TabulatedStringBuffer appendLine(String line) {
        this.lines.add(new StringBuilder(this.getIndent()).append(line));
        return this;
    }

    public TabulatedStringBuffer newLine() {
        this.lines.add(new StringBuilder(this.getIndent()));
        return this;
    }

    public TabulatedStringBuffer indent() {
        this.indentSize += 2;
        this.dirty = true;
        return this;
    }

    public TabulatedStringBuffer outdent() {
        this.indentSize = Math.max(this.indentSize - 2, 0);
        this.dirty = true;
        return this;
    }

    private String getIndent() {
        if (this.dirty) {
            int length = this.indent.length();
            if (this.indentSize > length) {
                StringBuilder buf = new StringBuilder(this.indent);
                while (length < this.indentSize) {
                    buf.append("  ");
                    length += 2;
                }
                this.indent = buf.toString();
            } else {
                this.indent = this.indent.substring(0, this.indentSize);
            }
            this.dirty = false;
        }
        return this.indent;
    }

    public Stream<String> getLines() {
        return this.lines.stream().map(StringBuilder::toString);
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.lines);
    }
}

