/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"SimpleConfig");
    private final HashMap<String, String> config = new HashMap();
    private final ConfigRequest request;
    private Set<String> edited = new HashSet<String>();
    private boolean broken = false;
    private static boolean modified = false;

    public static ConfigRequest of(String filename) {
        Path path = FabricLoader.getInstance().getConfigDir();
        return new ConfigRequest(path.resolve(filename + ".properties").toFile(), filename);
    }

    private void createConfig() throws IOException {
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, "UTF-8");
        writer.write(this.request.getConfig());
        writer.close();
    }

    private void loadConfig() throws IOException {
        Scanner reader = new Scanner(this.request.file);
        int line = 1;
        while (reader.hasNextLine()) {
            this.parseConfigEntry(reader.nextLine(), line);
            ++line;
        }
        reader.close();
    }

    private void parseConfigEntry(String entry, int line) {
        if (!entry.isEmpty() && !entry.startsWith("#")) {
            String[] parts = entry.split("=", 2);
            if (parts.length == 2) {
                this.config.put(parts[0], parts[1]);
            } else {
                throw new RuntimeException("Syntax error in config file on line " + line + "!");
            }
        }
    }

    private void writeConfig() throws IOException {
        Scanner reader = new Scanner(this.request.file);
        Object newConfig = "";
        while (reader.hasNextLine()) {
            String entry = reader.nextLine();
            if (!entry.isEmpty() && !entry.startsWith("#")) {
                String[] parts = entry.split("=", 2);
                if (parts.length == 2 && this.edited.contains(parts[0])) {
                    newConfig = (String)newConfig + parts[0] + "=" + this.config.get(parts[0]) + "\n";
                    this.edited.remove(parts[0]);
                    continue;
                }
                newConfig = (String)newConfig + entry + "\n";
                continue;
            }
            newConfig = (String)newConfig + entry + "\n";
        }
        reader.close();
        this.request.file.delete();
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, "UTF-8");
        writer.write((String)newConfig);
        writer.close();
    }

    private SimpleConfig(ConfigRequest request) {
        this.request = request;
        String identifier = "Config '" + request.filename + "'";
        if (!request.file.exists()) {
            LOGGER.info(identifier + " is missing, generating default one...");
            try {
                this.createConfig();
            }
            catch (IOException e) {
                LOGGER.error(identifier + " failed to generate!");
                LOGGER.trace((Object)e);
                this.broken = true;
            }
        }
        if (!this.broken) {
            try {
                this.loadConfig();
            }
            catch (Exception e) {
                LOGGER.error(identifier + " failed to load!");
                LOGGER.trace((Object)e);
                this.broken = true;
            }
        }
    }

    @Deprecated
    public String get(String key) {
        return this.config.get(key);
    }

    public void set(String key, String value) {
        String previousValue = this.config.get(key);
        this.config.replace(key, value);
        this.edited.add(key);
        modified = modified || !previousValue.equals(value);
    }

    public void writeIfModified() {
        if (modified) {
            this.writeToFile();
        }
    }

    public void writeToFile() {
        try {
            this.writeConfig();
            modified = false;
        }
        catch (IOException e) {
            System.out.println("Could not write to config file!");
            e.printStackTrace();
        }
    }

    public void reconstructFile() {
        if (!this.broken) {
            this.edited.addAll(this.config.keySet());
        }
        try {
            Files.deleteIfExists(this.request.file.toPath());
            this.createConfig();
            this.writeToFile();
            this.loadConfig();
            this.broken = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOrDefault(String key, String def) {
        String val = this.get(key);
        if (val == null) {
            this.broken = true;
        }
        return val == null ? def : val;
    }

    public int getOrDefault(String key, int def) {
        try {
            return Integer.parseInt(this.get(key));
        }
        catch (Exception e) {
            this.broken = true;
            return def;
        }
    }

    public boolean getOrDefault(String key, boolean def) {
        String val = this.get(key);
        if (val != null) {
            return val.equalsIgnoreCase("true");
        }
        this.broken = true;
        return def;
    }

    public double getOrDefault(String key, double def) {
        try {
            return Double.parseDouble(this.get(key));
        }
        catch (Exception e) {
            this.broken = true;
            return def;
        }
    }

    public boolean isBroken() {
        return this.broken;
    }

    public boolean delete() {
        LOGGER.warn("Config '" + this.request.filename + "' was removed from existence! Restart the game to regenerate it.");
        return this.request.file.delete();
    }

    public static class ConfigRequest {
        private File file;
        private final String filename;
        private DefaultConfig provider;

        private ConfigRequest(File file, String filename) {
            this.file = file;
            this.filename = filename;
            this.provider = DefaultConfig::empty;
        }

        public ConfigRequest provider(DefaultConfig provider) {
            this.provider = provider;
            return this;
        }

        public SimpleConfig request() {
            return new SimpleConfig(this);
        }

        private String getConfig() {
            return this.provider.get(this.filename) + "\n";
        }
    }

    public static interface DefaultConfig {
        public String get(String var1);

        public static String empty(String namespace) {
            return "";
        }
    }
}

