/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.ui.MultiLineTextFieldWidget;
import bettercommandblockui.mixin.CommandSuggestorAccessor;
import bettercommandblockui.mixin.SuggestionWindowAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import net.minecraft.class_5481;
import net.minecraft.class_768;

public class MultiLineCommandSuggestor
extends class_4717 {
    private static final List<class_2583> HIGHLIGHT_STYLES = (List)Stream.of(class_124.field_1061, class_124.field_1080, class_124.field_1075, class_124.field_1054, class_124.field_1060, class_124.field_1076, class_124.field_1065).map(arg_0 -> ((class_2583)class_2583.field_24360).method_10977(arg_0)).collect(ImmutableList.toImmutableList());
    private CommandSuggestorAccessor accessor = (CommandSuggestorAccessor)((Object)this);
    private class_3545<Integer, Integer> startPos = ((MultiLineTextFieldWidget)this.accessor.getTextField()).getCharacterPos(0);
    private int x;
    private int y;

    public MultiLineCommandSuggestor(class_310 client, class_437 owner, class_342 textField, class_327 textRenderer, boolean slashOptional, boolean suggestingWhenEmpty, int inWindowIndexOffset, int maxSuggestionSize, boolean chatScreenSized, int color) {
        super(client, owner, textField, textRenderer, slashOptional, suggestingWhenEmpty, inWindowIndexOffset, maxSuggestionSize, chatScreenSized, color);
    }

    public void method_23923(class_332 context, int mouseX, int mouseY) {
        context.method_25294(this.x - 1, this.y - 1, this.x + 1, this.y + 1, 0xFF8000);
        if (this.accessor.getWindow() != null) {
            this.accessor.getWindow().method_2373(context, mouseX, mouseY);
        } else {
            int i = 0;
            for (class_5481 orderedText : this.accessor.getMessages()) {
                int j = i * 10;
                context.method_25294(this.x - 1, j + this.y, this.x + this.accessor.getWidth() + 1, j + 12 + this.y, this.accessor.getColor());
                context.method_35720(this.accessor.getTextRenderer(), orderedText, this.x, this.y + j + 2, -1);
                ++i;
            }
        }
    }

    public void method_23934() {
        super.method_23934();
        this.refreshRenderPos();
    }

    public void refreshRenderPos() {
        block3: {
            try {
                SuggestionWindowAccessor window = (SuggestionWindowAccessor)this.accessor.getWindow();
                if (window == null) break block3;
                class_768 area = new class_768(this.x, this.y, window.getArea().method_3319(), window.getArea().method_3320());
                window.setArea(area);
            }
            catch (Exception e) {
                System.out.println("[MLCS::refreshRenderPos] Error:");
                for (StackTraceElement el : e.getStackTrace()) {
                    System.out.println(el);
                }
            }
        }
    }

    public class_2583 getColor(int colorIndex) {
        return HIGHLIGHT_STYLES.get(colorIndex);
    }

    public List<class_3545<Integer, Integer>> getColors(String original, int firstCharacterIndex) {
        int m;
        if (this.accessor.getParse() == null) {
            return new ArrayList<class_3545<Integer, Integer>>();
        }
        ParseResults<class_2172> parse = this.accessor.getParse();
        ArrayList list = Lists.newArrayList();
        list.add(new class_3545((Object)1, (Object)0));
        int colorIndex = -1;
        CommandContextBuilder commandContextBuilder = parse.getContext();
        block0: do {
            for (ParsedArgument parsedArgument : commandContextBuilder.getArguments().values()) {
                colorIndex = this.bumpColorIndex(colorIndex);
                int k = Math.max(parsedArgument.getRange().getStart() - firstCharacterIndex, 0);
                if (k >= original.length()) continue block0;
                int l = Math.min(parsedArgument.getRange().getEnd() - firstCharacterIndex, original.length());
                if (l <= 0) continue;
                list.add(new class_3545((Object)(colorIndex + 2), (Object)k));
                list.add(new class_3545((Object)1, (Object)l));
            }
        } while ((commandContextBuilder = commandContextBuilder.getChild()) != null);
        if (parse.getReader().canRead() && (m = Math.max(parse.getReader().getCursor() - firstCharacterIndex, 0)) < original.length()) {
            int n = Math.min(m + parse.getReader().getRemainingLength(), original.length());
            list.add(new class_3545((Object)0, (Object)m));
        }
        return list;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getHighlighColorCount() {
        return HIGHLIGHT_STYLES.size() - 2;
    }

    private int bumpColorIndex(int colorIndex) {
        return (colorIndex + 1) % this.getHighlighColorCount();
    }
}

