/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.BetterCommandBlockUI;
import bettercommandblockui.main.ui.MultiLineCommandSuggestor;
import bettercommandblockui.main.ui.ScrollbarWidget;
import bettercommandblockui.main.ui.TextFieldScrollbarWidget;
import bettercommandblockui.main.ui.screen.AbstractBetterCommandBlockScreen;
import bettercommandblockui.mixin.TextFieldWidgetAccessor;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import me.shurik.betterhighlighting.api.BuiltinGrammar;
import me.shurik.betterhighlighting.api.TextMateRegistry;
import me.shurik.betterhighlighting.api.syntax.Tokenizer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3544;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_5251;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.theme.Theme;

public class MultiLineTextFieldWidget
extends class_342
implements class_364 {
    private final int visibleChars = 20;
    private AbstractBetterCommandBlockScreen screen;
    private ScrollbarWidget scrollX;
    private ScrollbarWidget scrollY;
    private List<String> lines;
    private List<Integer> lineOffsets;
    private List<Integer> textOffsets;
    private List<class_3545<class_2583, Integer>> textColors;
    private int visibleLines = 11;
    private int scrolledLines = 0;
    private int horizontalOffset = 0;
    private int maxLineWidth = 30;
    private class_3545<Integer, Integer> cursorPosPreference;
    private boolean LShiftPressed;
    private boolean RShiftPressed = false;
    private boolean hasCommandSuggestor = false;
    private boolean textModified = false;
    private MultiLineCommandSuggestor suggestor;
    private TextFieldWidgetAccessor accessor = (TextFieldWidgetAccessor)((Object)this);
    private float timeSinceClick = 0.0f;

    public MultiLineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text, AbstractBetterCommandBlockScreen screen) {
        super(textRenderer, x, y, width, height, text);
        this.lines = new LinkedList<String>();
        this.lineOffsets = new LinkedList<Integer>();
        this.textOffsets = new LinkedList<Integer>();
        this.visibleLines = (height - 4) / 10;
        this.scrolledLines = 0;
        this.screen = screen;
        this.scrollX = new TextFieldScrollbarWidget(x, y + height + 1, width, 10, class_2561.method_30163((String)""), this, true);
        this.scrollY = new TextFieldScrollbarWidget(x + width + 1, y, 10, height, class_2561.method_30163((String)""), this, false);
        this.cursorPosPreference = new class_3545((Object)0, (Object)0);
    }

    public void method_25358(int width) {
        this.field_22758 = width;
        this.scrollX.method_25358(width);
    }

    public void method_53533(int height) {
        this.field_22759 = height;
        this.visibleLines = (height - 4) / 10;
        this.scrollY.method_53533(height);
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.scrollX.method_46421(x);
        this.scrollY.method_46421(x + this.field_22758 + 1);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.scrollX.method_46419(y + this.field_22759 + 1);
        this.scrollY.method_46419(y);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int color;
        this.timeSinceClick += delta / 20.0f;
        if (!this.method_1885()) {
            return;
        }
        if (this.accessor.getDrawsBackground()) {
            color = this.method_25370() ? -1 : -6250336;
            context.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, color);
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
        }
        int n = color = this.accessor.getEditable() ? this.accessor.getEditableColor() : this.accessor.getUneditableColor();
        if (this.hasCommandSuggestor) {
            if (this.lines.isEmpty()) {
                this.renderSuggestor(context, mouseX, mouseY);
                return;
            }
            for (int i = this.scrolledLines; i < this.scrolledLines + this.visibleLines && i < this.lines.size(); ++i) {
                String line = this.lines.get(i);
                if (line.length() < this.horizontalOffset) continue;
                line = line.substring(this.horizontalOffset);
                line = this.accessor.getTextRenderer().method_27523(line, this.method_1859());
                this.drawColoredLine(context, line, this.method_46426() + 5, this.method_46427() + 10 * (i - this.scrolledLines) + 5, i);
            }
        } else {
            this.drawRawText(context, this.accessor.getText(), this.method_46426() + 5, this.method_46427() + 5, color);
        }
        this.scrollX.method_25394(context, mouseX, mouseY, delta);
        this.scrollY.method_25394(context, mouseX, mouseY, delta);
        if (!this.hasCommandSuggestor) {
            return;
        }
        int selectionStart = this.accessor.getSelectionStart();
        int selectionEnd = this.accessor.getSelectionEnd();
        boolean selectingBackwards = false;
        if (selectionStart > selectionEnd) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
            selectingBackwards = true;
        }
        class_3545<Integer, Integer> start = this.indexToLineAndOffset(selectionStart);
        class_3545<Integer, Integer> end = this.indexToLineAndOffset(selectionEnd);
        int firstSelectedLine = (Integer)start.method_15442();
        int selectionStartOffset = (Integer)start.method_15441();
        int lastSelectedLine = (Integer)end.method_15442();
        int selectionEndOffset = (Integer)end.method_15441();
        selectionStartOffset -= this.horizontalOffset;
        selectionEndOffset -= this.horizontalOffset;
        selectionStartOffset = Math.max(selectionStartOffset, 0);
        selectionEndOffset = Math.max(selectionEndOffset, 0);
        boolean renderVerticalCursor = selectionStart < this.accessor.getText().length();
        boolean verticalCursorVisible = this.method_25370() && (class_156.method_658() - this.accessor.getLastSwitchFocusTime()) / 300L % 2L == 0L;
        for (int i = firstSelectedLine; i <= lastSelectedLine; ++i) {
            int x1;
            if (i < this.scrolledLines || i >= this.scrolledLines + this.visibleLines) continue;
            int x2 = x1 = this.method_46426() + 5;
            int y = this.method_46427() + 10 * (i - this.scrolledLines) + 5;
            String visibleLine = this.lines.get(i).substring(Math.min(this.horizontalOffset, this.lines.get(i).length()));
            if (i == firstSelectedLine) {
                x1 += this.accessor.getTextRenderer().method_1727(visibleLine.substring(0, Math.min(selectionStartOffset, visibleLine.length())));
                if (verticalCursorVisible && !selectingBackwards) {
                    if (renderVerticalCursor) {
                        Objects.requireNonNull(this.accessor.getTextRenderer());
                        context.method_25294(x1, y - 1, x1 + 1, y + 1 + 9, -3092272);
                    } else {
                        context.method_25303(this.accessor.getTextRenderer(), "_", x1, y, -3092272);
                    }
                }
            }
            if (i == lastSelectedLine) {
                x2 += this.accessor.getTextRenderer().method_1727(visibleLine.substring(0, Math.min(selectionEndOffset, visibleLine.length())));
                if (verticalCursorVisible && renderVerticalCursor && selectingBackwards) {
                    Objects.requireNonNull(this.accessor.getTextRenderer());
                    context.method_25294(x2, y - 1, x2 + 1, y + 1 + 9, -3092272);
                }
            } else {
                x2 += this.method_1859();
            }
            context.method_72238(x1, y, x2, y + 10);
        }
        this.renderSuggestor(context, mouseX, mouseY);
    }

    private void renderSuggestor(class_332 context, int mouseX, int mouseY) {
        if (this.suggestor.getY() > this.method_46427() + this.method_25364() || this.suggestor.getY() < this.method_46427()) {
            return;
        }
        if (this.suggestor.getX() > this.method_46426() + this.method_25368() || this.suggestor.getX() < this.method_46426()) {
            return;
        }
        this.suggestor.method_23923(context, mouseX, mouseY);
    }

    private void drawColoredLine(class_332 context, String content, int x, int y, int lineIndex) {
        class_327 textRenderer = this.accessor.getTextRenderer();
        int renderOffset = 0;
        int startOffset = this.textOffsets.get(lineIndex);
        int currentOffset = 0;
        int numSpaces = this.lineOffsets.get(lineIndex);
        if (this.textColors.size() > 1) {
            for (int i = 0; i < this.textColors.size() && currentOffset < content.length(); ++i) {
                int nextColorStart = i + 1 < this.textColors.size() ? (Integer)this.textColors.get(i + 1).method_15441() : startOffset + content.length();
                nextColorStart -= startOffset;
                if ((nextColorStart += numSpaces - this.horizontalOffset) > currentOffset) {
                    int color;
                    String substring = content.substring(currentOffset, this.clamp(nextColorStart, currentOffset, content.length()));
                    try {
                        color = ((class_2583)this.textColors.get(i).method_15442()).method_10973().method_27716();
                    }
                    catch (IndexOutOfBoundsException e) {
                        color = class_5251.method_27718((class_124)class_124.field_1080).method_27716();
                    }
                    context.method_25303(textRenderer, substring, x + renderOffset, y, color |= 0xFF000000);
                    currentOffset += substring.length();
                    renderOffset += textRenderer.method_1727(substring);
                }
                if (currentOffset <= content.length()) {
                    continue;
                }
                break;
            }
        } else {
            int color;
            try {
                color = ((class_2583)this.textColors.get(0).method_15442()).method_10973().method_27716();
            }
            catch (IndexOutOfBoundsException e) {
                color = class_5251.method_27718((class_124)class_124.field_1080).method_27716();
            }
            context.method_25303(textRenderer, content, x, y, color |= 0xFF000000);
        }
    }

    private void drawRawText(class_332 context, String content, int x, int y, int color) {
        class_327 textRenderer = this.accessor.getTextRenderer();
        String line = content.substring(Math.max(Math.min(this.horizontalOffset, content.length() - 1), 0));
        String trimmedLine = textRenderer.method_27523(line, this.method_1859());
        context.method_25303(textRenderer, trimmedLine, x, y, color);
    }

    private int pointToIndex(double x, double y) {
        if (this.lines.size() > 0) {
            class_327 textRenderer = this.accessor.getTextRenderer();
            int lineIndex = (int)Math.floor((y - (double)(this.method_46427() + 5)) / 10.0) + this.scrolledLines;
            lineIndex = Math.max(Math.min(lineIndex, this.lines.size() - 1), 0);
            String line = this.lines.get(lineIndex);
            int offset = 0;
            if (line.length() > 0) {
                String visibleLine = line.substring(Math.min(this.horizontalOffset, line.length()));
                String trimmedLine = textRenderer.method_27523(visibleLine, (int)(x - (double)(this.method_46426() + 5)));
                boolean characterClicked = trimmedLine.length() < visibleLine.length();
                boolean lineEndLeftOfWindow = this.horizontalOffset > line.length() - 1;
                int lineOffset = this.lineOffsets.get(lineIndex);
                boolean offsetClicked = trimmedLine.length() < lineOffset - this.horizontalOffset;
                offset = Math.min(this.horizontalOffset + trimmedLine.length() - lineOffset, line.length() - lineOffset);
                offset = Math.max(offset, 0);
                offset += offsetClicked ? 1 : 0;
            }
            return this.textOffsets.get(lineIndex) + Math.max(offset, 0);
        }
        return 0;
    }

    private class_3545<Integer, Integer> indexToLineAndOffset(int index) {
        class_3545 output = new class_3545((Object)0, (Object)0);
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.textOffsets.get(i) + (this.lines.get(i).length() - this.lineOffsets.get(i)) + 1 <= index) continue;
            output.method_34964((Object)i);
            output.method_34965((Object)(index - this.textOffsets.get(i) + this.lineOffsets.get(i)));
            return output;
        }
        return output;
    }

    public class_3545<Integer, Integer> getCharacterPos(int index) {
        int x;
        class_3545<Integer, Integer> output = this.indexToLineAndOffset(index);
        try {
            x = this.method_46426() + 5 + this.accessor.getTextRenderer().method_1727(this.lines.get((Integer)output.method_15442()).substring(this.horizontalOffset, (Integer)output.method_15441()));
        }
        catch (Exception e) {
            x = 0;
        }
        int y = this.method_46427() + 5 + 10 * ((Integer)output.method_15442() - this.scrolledLines);
        return new class_3545((Object)x, (Object)y);
    }

    public void setCommandSuggestor(MultiLineCommandSuggestor newSuggestor) {
        this.suggestor = newSuggestor;
        this.hasCommandSuggestor = true;
    }

    public void method_1867(String text) {
        String string;
        int l;
        int i = Math.min(this.accessor.getSelectionStart(), this.accessor.getSelectionEnd());
        int j = Math.max(this.accessor.getSelectionStart(), this.accessor.getSelectionEnd());
        int k = this.accessor.invokeGetMaxLength() - this.accessor.getText().length() - (i - j);
        if (k < (l = (string = class_3544.method_57180((String)text)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        String string2 = new StringBuilder(this.accessor.getText()).replace(i, j, string).toString();
        if (!this.accessor.getTextPredicate().test(string2)) {
            return;
        }
        this.accessor.setTextVariable(string2);
        this.method_1875(i + l);
        this.method_1884(this.accessor.getSelectionStart());
        this.onChanged(this.accessor.getText(), true);
        this.updateScrollPositions();
        this.textModified = true;
    }

    private void erase(int offset) {
        if (class_310.method_1551().method_74188()) {
            this.method_1877(offset);
        } else {
            this.method_1878(offset);
        }
        this.onChanged(this.accessor.getText(), true);
        this.updateScrollPositions();
        this.textModified = true;
    }

    private boolean isAlphanumeric(char a) {
        return Character.isLetter(a) || Character.isDigit(a) || a == '_';
    }

    private int getWordLength(int offsetDir) {
        char current;
        int startIndex = this.accessor.getSelectionStart() + (offsetDir < 0 ? -1 : 0);
        String text = this.method_1882();
        if (text.isEmpty() || startIndex < 0 || startIndex >= text.length()) {
            return 0;
        }
        char startChar = current = text.charAt(startIndex);
        boolean erasingAlphanumeric = this.isAlphanumeric(startChar);
        int endIndex = startIndex;
        while ((endIndex += offsetDir) >= 0 && endIndex < text.length()) {
            current = text.charAt(endIndex);
            if (erasingAlphanumeric && this.isAlphanumeric(current) || !erasingAlphanumeric && current == startChar) continue;
        }
        int min = Math.min(startIndex, endIndex -= offsetDir);
        int max = Math.max(startIndex, endIndex);
        return (max - min + 1) * offsetDir;
    }

    private void selectWord() {
        int forward = this.getWordLength(1);
        int backward = this.getWordLength(-1);
        this.accessor.setSelectionStart(this.accessor.getSelectionStart() + forward);
        this.accessor.setSelectionEnd(this.accessor.getSelectionStart() - forward + backward);
    }

    public void method_1877(int wordOffset) {
        if (this.accessor.getText().isEmpty()) {
            return;
        }
        if (this.accessor.getSelectionEnd() != this.accessor.getSelectionStart()) {
            this.method_1867("");
            return;
        }
        this.method_1878(this.getWordLength(wordOffset));
    }

    public void method_1878(int characterOffset) {
        int k;
        if (this.accessor.getText().isEmpty()) {
            return;
        }
        if (this.accessor.getSelectionEnd() != this.accessor.getSelectionStart()) {
            this.method_1867("");
            return;
        }
        int i = this.accessor.invokeGetCursorPosWithOffset(characterOffset);
        int j = Math.min(i, this.accessor.getSelectionStart());
        if (j == (k = Math.max(i, this.accessor.getSelectionStart()))) {
            return;
        }
        String string = new StringBuilder(this.accessor.getText()).delete(j, k).toString();
        if (!this.accessor.getTextPredicate().test(string)) {
            return;
        }
        this.accessor.setTextVariable(string);
        this.method_1883(j, false);
    }

    public boolean method_25404(class_11908 input) {
        int keyCode = input.method_74228();
        if (keyCode == 340) {
            this.LShiftPressed = true;
        }
        if (keyCode == 344) {
            this.RShiftPressed = true;
        }
        if (!this.method_20315()) {
            return false;
        }
        if (input.method_74241()) {
            this.method_1872(class_310.method_1551().method_74187());
            this.method_1884(0);
            return true;
        }
        if (input.method_74242()) {
            class_310.method_1551().field_1774.method_1455(this.method_1866());
            return true;
        }
        if (input.method_74243()) {
            if (this.accessor.getEditable()) {
                this.method_1867(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (input.method_74244()) {
            class_310.method_1551().field_1774.method_1455(this.method_1866());
            if (this.accessor.getEditable()) {
                this.method_1867("");
            }
            return true;
        }
        switch (keyCode) {
            case 263: {
                if (class_310.method_1551().method_74188()) {
                    this.method_1883(this.method_1881() + this.getWordLength(-1), class_310.method_1551().method_74187());
                    this.updateScrollPositions();
                } else {
                    this.method_1855(-1, class_310.method_1551().method_74187());
                }
                return true;
            }
            case 264: {
                this.moveCursorVertical(1);
                return true;
            }
            case 265: {
                this.moveCursorVertical(-1);
                return true;
            }
            case 262: {
                if (class_310.method_1551().method_74188()) {
                    this.method_1883(this.method_1881() + this.getWordLength(1), class_310.method_1551().method_74187());
                    this.updateScrollPositions();
                } else {
                    this.method_1855(1, class_310.method_1551().method_74187());
                }
                return true;
            }
            case 259: {
                if (this.accessor.getEditable()) {
                    this.erase(-1);
                }
                return true;
            }
            case 261: {
                if (this.accessor.getEditable()) {
                    this.erase(1);
                }
                return true;
            }
            case 268: {
                this.method_1870(class_310.method_1551().method_74187());
                this.updateScrollPositions();
                return true;
            }
            case 269: {
                this.method_1872(class_310.method_1551().method_74187());
                this.updateScrollPositions();
                return true;
            }
        }
        return false;
    }

    public boolean method_16803(class_11908 input) {
        int keyCode = input.method_74228();
        if (keyCode == 340) {
            this.LShiftPressed = false;
        }
        if (keyCode == 344) {
            this.RShiftPressed = false;
        }
        return super.method_16803(input);
    }

    public boolean method_25400(class_11905 input) {
        if (!this.method_20315()) {
            return false;
        }
        if (input.method_74227()) {
            if (this.accessor.getEditable()) {
                String chr = input.method_74226();
                this.method_1867(chr);
                if (BetterCommandBlockUI.BRACKET_AUTOCOMPLETE) {
                    if (chr.equals("{")) {
                        this.method_1867(Character.toString('}'));
                    } else if (chr.equals("[")) {
                        this.method_1867(Character.toString(']'));
                    }
                }
            }
            this.textModified = true;
            return true;
        }
        return false;
    }

    public void method_1852(String text) {
        if (!this.accessor.getTextPredicate().test(text)) {
            return;
        }
        this.accessor.setTextVariable(text.length() > this.accessor.invokeGetMaxLength() ? text.substring(0, this.accessor.invokeGetMaxLength()) : text);
        this.method_1872(class_310.method_1551().method_74187());
        this.method_1884(this.accessor.getSelectionStart());
        this.onChanged(text, true);
    }

    public void setRawText(String text) {
        this.method_1852(text);
    }

    public void refreshFormatting() {
        this.setRawText(this.method_1882());
    }

    private void onChanged(String newText, boolean formatText) {
        if (this.accessor.getChangedListener() != null) {
            this.accessor.getChangedListener().accept(newText);
        }
        if (this.hasCommandSuggestor) {
            if (formatText) {
                this.formatText(newText);
            }
        } else {
            this.setUnformattedText(newText);
        }
        this.scrollY.setScale((double)this.lines.size() / (double)this.visibleLines);
        this.scrollX.setScale((double)this.maxLineWidth / 20.0);
        this.refreshSuggestorPos();
    }

    private void setUnformattedText(String text) {
        this.textColors = new LinkedList<class_3545<class_2583, Integer>>();
        this.textColors.add((class_3545<class_2583, Integer>)new class_3545((Object)class_2583.field_24360.method_10977(class_124.field_1080), (Object)0));
        this.lines = new LinkedList<String>();
        this.lines.add(text);
        this.lineOffsets = new LinkedList<Integer>();
        this.lineOffsets.add(0);
        this.textOffsets = new LinkedList<Integer>();
        this.textOffsets.add(0);
        this.maxLineWidth = 0;
        for (String line : this.lines) {
            this.maxLineWidth = Math.max(line.length(), this.maxLineWidth);
        }
    }

    private void submitLine(String line, int indent) {
        this.submitLine(line, indent, false);
    }

    private void submitLine(String line, int indent, boolean lastLine) {
        String trimmedLine;
        if (BetterCommandBlockUI.AVOID_DOUBLE_NEWLINE && !lastLine && (trimmedLine = line.replace("" + BetterCommandBlockUI.INDENTATION_CHAR, "")).isEmpty()) {
            return;
        }
        String indentChar = "" + BetterCommandBlockUI.INDENTATION_CHAR;
        this.lines.add(indentChar.repeat(indent * BetterCommandBlockUI.INDENTATION_FACTOR) + line);
        this.lineOffsets.add(indent * BetterCommandBlockUI.INDENTATION_FACTOR);
        if (this.textOffsets.isEmpty()) {
            this.textOffsets.add(0);
        } else {
            int index = this.textOffsets.size() - 1;
            this.textOffsets.add(this.textOffsets.get(index) + (this.lines.get(index).length() - this.lineOffsets.get(index)));
        }
    }

    private void formatText(String text) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.textColors = new LinkedList<class_3545<class_2583, Integer>>();
        List<class_3545<Integer, Integer>> colorIndices = this.suggestor.getColors(text, 0);
        Stack<Integer> colorStack = new Stack<Integer>();
        int currentColorListIndex = 0;
        int currentHighlightColor = 0;
        this.lines = new LinkedList<String>();
        this.lineOffsets = new LinkedList<Integer>();
        this.textOffsets = new LinkedList<Integer>();
        final char[] textArr = text.toCharArray();
        boolean linestart = false;
        int parenthesesDepth = 0;
        boolean singleQuoteString = false;
        boolean doubleQuoteString = false;
        boolean escapeChar = false;
        Object currentLine = "";
        boolean newLine = false;
        int lastWordStart = 0;
        SpacePeeker peeker = new SpacePeeker(){

            @Override
            public class_3545<Integer, String> run(int startIndex) {
                StringBuilder outputLine = new StringBuilder();
                int tempCurrentIndex = startIndex + 1;
                if (tempCurrentIndex < textArr.length) {
                    char tempCurrent = textArr[tempCurrentIndex];
                    while (tempCurrentIndex < textArr.length - 1 && tempCurrent == ' ') {
                        outputLine.append(tempCurrent);
                        tempCurrent = textArr[++tempCurrentIndex];
                    }
                    startIndex = tempCurrentIndex - 1;
                }
                return new class_3545((Object)startIndex, (Object)outputLine.toString());
            }
        };
        block9: for (int currentIndex = 0; currentIndex < textArr.length; ++currentIndex) {
            while (currentColorListIndex < colorIndices.size() && (Integer)colorIndices.get(currentColorListIndex).method_15441() < currentIndex) {
                colorStack.push((Integer)colorIndices.get(currentColorListIndex).method_15442());
                ++currentColorListIndex;
            }
            char current = textArr[currentIndex];
            if (textRenderer.method_1727((String)currentLine) > BetterCommandBlockUI.WRAPAROUND_WIDTH) {
                if (lastWordStart == 0) {
                    lastWordStart = ((String)currentLine).length();
                }
                String truncatedLine = ((String)currentLine).substring(0, Math.min(lastWordStart, ((String)currentLine).length()));
                this.submitLine(truncatedLine, parenthesesDepth);
                currentLine = truncatedLine.length() < ((String)currentLine).length() ? ((String)currentLine).substring(lastWordStart) : "";
                lastWordStart = 0;
            }
            int colorStartIndex = currentIndex;
            switch (current) {
                case '[': 
                case '{': {
                    escapeChar = false;
                    if (singleQuoteString || doubleQuoteString) {
                        currentLine = (String)currentLine + current;
                        newLine = false;
                        continue block9;
                    }
                    if (BetterCommandBlockUI.NEWLINE_PRE_OPEN_BRACKET) {
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                    }
                    currentLine = (String)currentLine + current;
                    if (BetterCommandBlockUI.NEWLINE_POST_OPEN_BRACKET) {
                        class_3545<Integer, String> peekResult = peeker.run(currentIndex);
                        currentIndex = (Integer)peekResult.method_15442();
                        currentLine = (String)currentLine + (String)peekResult.method_15441();
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                    }
                    if (newLine) {
                        ++parenthesesDepth;
                    }
                    if (currentColorListIndex <= 0) continue block9;
                    currentHighlightColor = (Integer)colorIndices.get(currentColorListIndex - 1).method_15442();
                    colorStack.push(currentHighlightColor);
                    if (currentHighlightColor == 0) continue block9;
                    colorIndices.add(currentColorListIndex, (class_3545<Integer, Integer>)new class_3545((Object)this.getHighlightColorIndex(currentHighlightColor + 1), (Object)colorStartIndex));
                    ++currentColorListIndex;
                    continue block9;
                }
                case ']': 
                case '}': {
                    class_3545<Integer, String> peekResult;
                    escapeChar = false;
                    if (singleQuoteString || doubleQuoteString) {
                        currentLine = (String)currentLine + current;
                        newLine = false;
                        continue block9;
                    }
                    boolean indentationChanged = false;
                    if (BetterCommandBlockUI.NEWLINE_PRE_CLOSE_BRACKET) {
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                        parenthesesDepth = Math.max(0, parenthesesDepth - 1);
                        indentationChanged = true;
                    }
                    currentLine = (String)currentLine + current;
                    if (BetterCommandBlockUI.NEWLINE_POST_CLOSE_BRACKET) {
                        peekResult = peeker.run(currentIndex);
                        currentIndex = (Integer)peekResult.method_15442();
                        currentLine = (String)currentLine + (String)peekResult.method_15441();
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                        if (!indentationChanged) {
                            parenthesesDepth = Math.max(0, parenthesesDepth - 1);
                        }
                    }
                    if (currentColorListIndex <= 0 || (Integer)colorIndices.get(currentColorListIndex - 1).method_15442() == 0) continue block9;
                    colorIndices.add(currentColorListIndex, (class_3545<Integer, Integer>)new class_3545((Object)((Integer)colorStack.pop()), (Object)(colorStartIndex + 1)));
                    ++currentColorListIndex;
                    continue block9;
                }
                case ',': {
                    escapeChar = false;
                    currentLine = (String)currentLine + current;
                    lastWordStart = ((String)currentLine).length();
                    class_3545<Integer, String> peekResult = peeker.run(currentIndex);
                    currentIndex = (Integer)peekResult.method_15442();
                    currentLine = (String)currentLine + (String)peekResult.method_15441();
                    if (!BetterCommandBlockUI.NEWLINE_POST_COMMA) continue block9;
                    this.submitLine((String)currentLine, parenthesesDepth);
                    lastWordStart = 0;
                    currentLine = "";
                    continue block9;
                }
                case ' ': {
                    currentLine = (String)currentLine + current;
                    newLine = false;
                    escapeChar = false;
                    lastWordStart = ((String)currentLine).length();
                    continue block9;
                }
                case '\\': {
                    escapeChar = !escapeChar;
                    currentLine = (String)currentLine + current;
                    newLine = false;
                    continue block9;
                }
                case '\"': {
                    if (!(BetterCommandBlockUI.FORMAT_STRINGS || singleQuoteString || escapeChar)) {
                        doubleQuoteString = !doubleQuoteString;
                        escapeChar = false;
                    }
                    currentLine = (String)currentLine + current;
                    continue block9;
                }
                case '\'': {
                    if (!BetterCommandBlockUI.FORMAT_STRINGS && !escapeChar) {
                        singleQuoteString = !singleQuoteString;
                        escapeChar = false;
                    }
                    currentLine = (String)currentLine + current;
                    continue block9;
                }
                default: {
                    currentLine = (String)currentLine + current;
                    newLine = false;
                    escapeChar = false;
                }
            }
        }
        if (!((String)currentLine).isEmpty()) {
            this.submitLine((String)currentLine, parenthesesDepth, true);
        }
        for (class_3545<Integer, Integer> p : colorIndices) {
            this.textColors.add((class_3545<class_2583, Integer>)new class_3545((Object)this.suggestor.getColor((Integer)p.method_15442()), (Object)((Integer)p.method_15441())));
        }
        if (!text.isEmpty() && FabricLoader.getInstance().isModLoaded("better-highlighting")) {
            this.transformTokenOutput(Tokenizer.tokenizeAndFormatComponent((String)text, (IGrammar)BuiltinGrammar.mcfunction(), (Theme)TextMateRegistry.instance().getCurrentTheme()).method_10855());
        }
        this.maxLineWidth = 0;
        for (String line : this.lines) {
            this.maxLineWidth = Math.max(line.length(), this.maxLineWidth);
        }
    }

    private int getHighlightColorIndex(int i) {
        int index = i - 2;
        int count = this.suggestor.getHighlighColorCount();
        if (index < 0) {
            index += count;
        }
        return index % count + 2;
    }

    private void transformTokenOutput(List<class_2561> output) {
        this.textColors.clear();
        int index = 0;
        for (class_2561 text : output) {
            if (text.method_10866().method_10973() != null) {
                this.textColors.add((class_3545<class_2583, Integer>)new class_3545((Object)text.method_10866(), (Object)index));
            }
            index += text.getString().length();
        }
    }

    private boolean getHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public void method_25348(class_11909 click, boolean doubled) {
        if (!this.method_1885()) {
            return;
        }
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        this.scrollX.method_25402(click, doubled);
        this.scrollY.method_25402(click, doubled);
        boolean hovered = this.getHovered(mouseX, mouseY);
        if (this.accessor.getFocusUnlocked()) {
            this.method_25365(hovered);
        }
        if (this.method_25370() && hovered && click.method_74245() == 0) {
            int previousIndex = this.accessor.getSelectionStart();
            this.method_1883(this.pointToIndex(mouseX, mouseY), class_310.method_1551().method_74187());
            this.cursorPosPreference = new class_3545((Object)((int)mouseX), (Object)((int)mouseY));
            if (doubled) {
                this.selectWord();
            }
            this.timeSinceClick = 0.0f;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.method_1885()) {
            return false;
        }
        if (this.screen != null && this.screen.scroll(verticalAmount)) {
            return true;
        }
        if (this.LShiftPressed || this.RShiftPressed) {
            this.horizontalOffset = this.clamp(this.horizontalOffset - (int)verticalAmount * BetterCommandBlockUI.SCROLL_STEP_X, 0, this.maxLineWidth - 20);
            this.scrollX.updatePos((double)this.horizontalOffset / (double)(this.maxLineWidth - 20));
        } else {
            this.scrolledLines = this.clamp(this.scrolledLines - (int)verticalAmount * BetterCommandBlockUI.SCROLL_STEP_Y, 0, this.lines.size() - this.visibleLines);
            this.scrollY.updatePos((double)this.scrolledLines / (double)(this.lines.size() - this.visibleLines));
        }
        this.refreshSuggestorPos();
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (!this.method_1885()) {
            return;
        }
        this.scrollX.method_16014(mouseX, mouseY);
        this.scrollY.method_16014(mouseX, mouseY);
    }

    public void method_25349(class_11909 click, double offsetX, double offsetY) {
        if (!this.method_1885()) {
            return;
        }
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        this.scrollX.method_25349(click, offsetX, offsetY);
        this.scrollY.method_25349(click, offsetX, offsetY);
        if (this.method_49606() && this.method_25370()) {
            this.method_1875(this.pointToIndex(mouseX, mouseY));
        }
    }

    public void method_25357(class_11909 click) {
        if (!this.method_1885()) {
            return;
        }
        this.scrollX.method_25406(click);
        this.scrollY.method_25406(click);
    }

    private void moveCursorVertical(int delta) {
        class_3545<Integer, Integer> lineAndOffset = this.indexToLineAndOffset(this.accessor.invokeGetCursorPosWithOffset(0));
        int yPreference = this.method_46427() + 5 + ((Integer)lineAndOffset.method_15442() - this.scrolledLines) * 10;
        this.cursorPosPreference.method_34965((Object)(yPreference + delta * 10));
        int index = this.pointToIndex(((Integer)this.cursorPosPreference.method_15442()).intValue(), ((Integer)this.cursorPosPreference.method_15441()).intValue());
        this.method_1883(index, class_310.method_1551().method_74187());
        this.updateScrollPositions();
    }

    public void method_1855(int offset, boolean shiftKeyPressed) {
        class_327 textRenderer = this.accessor.getTextRenderer();
        this.method_1883(this.accessor.invokeGetCursorPosWithOffset(offset), shiftKeyPressed);
        if (this.lines.isEmpty()) {
            return;
        }
        class_3545<Integer, Integer> lineAndOffset = this.indexToLineAndOffset(this.accessor.invokeGetCursorPosWithOffset(0));
        String line = this.lines.get((Integer)lineAndOffset.method_15442());
        int xPreference = this.method_46426() + textRenderer.method_1727(line.substring(0, Math.min(line.length() - 1, (Integer)lineAndOffset.method_15441())));
        this.cursorPosPreference = new class_3545((Object)xPreference, (Object)(this.method_46427() + 10 * ((Integer)lineAndOffset.method_15442() - this.scrolledLines)));
        this.updateScrollPositions();
    }

    private void updateScrollPositions() {
        int xPos;
        boolean lineEndLeftOfWindow;
        class_327 textRenderer = this.accessor.getTextRenderer();
        class_3545<Integer, Integer> lineAndOffset = this.indexToLineAndOffset(this.accessor.invokeGetCursorPosWithOffset(0));
        if (this.lines.size() < 1) {
            this.horizontalOffset = 0;
            this.scrollY.updatePos(0.0);
            this.scrolledLines = 0;
            this.scrollX.updatePos(0.0);
            return;
        }
        Object line = this.lines.get((Integer)lineAndOffset.method_15442());
        int maxIndex = ((String)line).length() - 1;
        boolean bl = lineEndLeftOfWindow = this.horizontalOffset > (Integer)lineAndOffset.method_15441();
        if (lineEndLeftOfWindow) {
            int extension = 1 + this.horizontalOffset - (Integer)lineAndOffset.method_15441();
            line = (String)line + "_".repeat(extension);
            xPos = textRenderer.method_1727(((String)line).substring(this.clamp((Integer)lineAndOffset.method_15441(), 0, maxIndex += extension), this.clamp(this.horizontalOffset, 0, maxIndex))) * -1;
        } else {
            xPos = textRenderer.method_1727(((String)line).substring(this.clamp(this.horizontalOffset, 0, maxIndex), this.clamp((Integer)lineAndOffset.method_15441(), 0, maxIndex)));
        }
        int textWidth = this.method_25368() - 8;
        if (xPos <= 5) {
            this.horizontalOffset = this.clamp(this.horizontalOffset + (xPos - 10) / 5, 0, this.maxLineWidth - 20);
            this.scrollX.updatePos((double)this.horizontalOffset / (double)(this.maxLineWidth - 20));
        } else if (xPos >= textWidth) {
            this.horizontalOffset = this.clamp(this.horizontalOffset + (xPos - textWidth) / 5, 0, this.maxLineWidth - 20);
            this.scrollX.updatePos((double)this.horizontalOffset / (double)(this.maxLineWidth - 20));
        }
        int lineIndex = (Integer)lineAndOffset.method_15442();
        if (lineIndex < this.scrolledLines) {
            this.scrolledLines = this.clamp(this.scrolledLines - (this.scrolledLines - lineIndex), 0, this.lines.size() - this.visibleLines);
            this.scrollY.updatePos((double)this.scrolledLines / (double)(this.lines.size() - this.visibleLines));
        } else if (lineIndex >= this.scrolledLines + this.visibleLines) {
            this.scrolledLines = this.clamp(this.scrolledLines + 1 + (lineIndex - this.scrolledLines - this.visibleLines), 0, this.lines.size() - this.visibleLines);
            this.scrollY.updatePos((double)this.scrolledLines / (double)(this.lines.size() - this.visibleLines));
        }
    }

    public void method_1883(int cursor, boolean shiftKeyPressed) {
        this.method_1875(cursor);
        if (!shiftKeyPressed) {
            this.method_1884(this.accessor.getSelectionStart());
        }
        this.onChanged(this.accessor.getText(), false);
    }

    public void setScroll(double value) {
        this.scrolledLines = (int)Math.max(Math.round((double)(this.lines.size() - this.visibleLines) * value), 0L);
        this.refreshSuggestorPos();
    }

    public void setHorizontalOffset(double value) {
        this.horizontalOffset = (int)Math.max(Math.floor((double)(this.maxLineWidth - 20) * value), 0.0);
        this.refreshSuggestorPos();
    }

    public void method_1888(boolean value) {
        super.method_1888(value);
        if (this.suggestor != null) {
            this.suggestor.method_23933(value);
        }
    }

    public boolean wasModified() {
        return this.textModified;
    }

    public void resetModified() {
        this.textModified = false;
    }

    void refreshSuggestorPos() {
        int selectionEnd;
        if (!this.hasCommandSuggestor) {
            return;
        }
        int selectionStart = this.accessor.getSelectionStart();
        if (selectionStart > (selectionEnd = this.accessor.getSelectionEnd())) {
            selectionStart = selectionEnd;
        }
        class_3545<Integer, Integer> cursor = this.indexToLineAndOffset(selectionStart);
        int selectionStartOffset = Math.max((Integer)cursor.method_15441() - this.horizontalOffset, 0);
        Objects.requireNonNull(this.accessor.getTextRenderer());
        int fontHeight = 9 + 1;
        if (this.lines.isEmpty()) {
            this.suggestor.setPos(this.method_46426() + 5, this.method_46427() + 5 + fontHeight);
            this.suggestor.refreshRenderPos();
            return;
        }
        String line = this.lines.get((Integer)cursor.method_15442());
        line = line.substring(this.clamp(this.horizontalOffset, 0, line.length()));
        int x = this.method_46426() + 5 + this.accessor.getTextRenderer().method_1727(line.substring(0, Math.min(selectionStartOffset, line.length())));
        int y = this.method_46427() + 5 + fontHeight + ((Integer)cursor.method_15442() - this.scrolledLines) * fontHeight;
        this.suggestor.setPos(x, y);
        this.suggestor.refreshRenderPos();
    }

    private int clamp(int i, int min, int max) {
        return Math.max(Math.min(i, max), min);
    }

    private double clamp(double i, double min, double max) {
        return Math.max(Math.min(i, max), min);
    }

    private void printStackTrace() {
        try {
            int[] i = new int[]{};
            i[1] = 0;
        }
        catch (Exception e) {
            StackTraceElement[] stacktrace;
            System.out.println("=================");
            for (StackTraceElement element : stacktrace = e.getStackTrace()) {
                System.out.println(element);
            }
            System.out.println("=================");
        }
    }

    private static interface SpacePeeker {
        public class_3545<Integer, String> run(int var1);
    }
}

