/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.BetterCommandBlockUI;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class ScrollbarWidget
extends class_339 {
    protected boolean dragging = false;
    protected boolean horizontal = false;
    protected double prevMouseX = 0.0;
    protected double prevMouseY = 0.0;
    protected double pos = 0.0;
    protected double scale;
    protected int length;
    protected int barLength;
    protected int frameRepeatLength;
    protected int barRepeatLength;
    protected final int textureLength = 256;
    protected Consumer<Double> changedListener;

    public ScrollbarWidget(int x, int y, int width, int height, class_2561 message, boolean horizontal) {
        super(x, y, width, height, message);
        this.horizontal = horizontal;
        this.scale = 1.0;
        this.length = horizontal ? width : height;
        this.barLength = (int)((double)this.length / this.scale);
        this.frameRepeatLength = this.length - 256;
        this.barRepeatLength = this.barLength - 256;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }
        this.field_22762 = this.checkHovered(mouseX, mouseY);
        this.renderFrame(context);
        this.renderSlider(context, mouseX, mouseY, delta);
    }

    protected void renderFrame(class_332 context) {
        this.renderLongBox(context, false, false, 0, this.horizontal ? this.field_22758 : this.field_22759, this.frameRepeatLength);
    }

    protected void renderSlider(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderLongBox(context, true, this.field_22762, (int)(this.pos * (double)(this.length - this.barLength)), this.barLength, this.barRepeatLength);
    }

    protected void renderLongBox(class_332 context, boolean enabled, boolean hovered, int position, int boxLength, int repeatLength) {
        if (this.horizontal) {
            class_2960 textures = BetterCommandBlockUI.SCROLLBAR_HORIZONTAL.method_52729(enabled, hovered);
            context.method_70846(class_10799.field_56883, textures, 256, 10, 0, 0, this.method_46426() + position, this.method_46427(), Math.min(boxLength / 2, 128), this.field_22759);
            context.method_70846(class_10799.field_56883, textures, 256, 10, Math.max(128, 256 - boxLength / 2), 0, Math.max(this.method_46426() + position + boxLength / 2, this.method_46426() + position + boxLength - 128), this.method_46427(), Math.min(boxLength / 2, 128), this.field_22759);
            int drawX = this.method_46426() + position + 128;
            for (int i = 0; i < repeatLength / 128 + 1; ++i) {
                context.method_70846(class_10799.field_56883, textures, 256, 10, 64, 0, drawX, this.method_46427(), Math.min(repeatLength - i * 256 / 2, 128), this.field_22759);
                drawX += 128;
            }
        } else {
            class_2960 textures = BetterCommandBlockUI.SCROLLBAR_VERTICAL.method_52729(enabled, hovered);
            context.method_70846(class_10799.field_56883, textures, 10, 256, 0, 0, this.method_46426(), this.method_46427() + position, this.field_22758, Math.min(boxLength / 2, 128));
            context.method_70846(class_10799.field_56883, textures, 10, 256, 0, Math.max(128, 256 - boxLength / 2), this.method_46426(), Math.max(this.method_46427() + position + boxLength / 2, this.method_46427() + position + boxLength - 128), this.field_22758, Math.min(boxLength / 2, 128));
            int drawY = this.method_46427() + 128;
            for (int i = 0; i < repeatLength / 128 + 1; ++i) {
                context.method_70846(class_10799.field_56883, textures, 10, 256, 0, 64, this.method_46426(), drawY, this.field_22758, Math.min(repeatLength - i * 256 / 2, 128));
                drawY += 128;
            }
        }
    }

    public void setChangedListener(Consumer<Double> changedListener) {
        this.changedListener = changedListener;
    }

    protected boolean checkHovered(double mouseX, double mouseY) {
        if (this.horizontal) {
            return mouseX >= (double)this.method_46426() + this.pos * (double)(this.length - this.barLength) && mouseY >= (double)this.method_46427() && mouseX < (double)this.method_46426() + this.pos * (double)(this.length - this.barLength) + (double)this.barLength && mouseY < (double)(this.method_46427() + this.field_22759);
        }
        return mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() + this.pos * (double)(this.length - this.barLength) && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY < (double)this.method_46427() + this.pos * (double)(this.length - this.barLength) + (double)this.barLength;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.method_25351(click.comp_4800()) && this.checkHovered(click.comp_4798(), click.comp_4799())) {
            this.method_25354(class_310.method_1551().method_1483());
            this.method_25348(click, doubled);
            return true;
        }
        return false;
    }

    public void method_25348(class_11909 click, boolean doubled) {
        if (!this.field_22764) {
            return;
        }
        this.dragging = true;
        this.prevMouseX = click.comp_4798();
        this.prevMouseY = click.comp_4799();
    }

    public void method_25357(class_11909 click) {
        if (!this.field_22764) {
            return;
        }
        this.dragging = false;
    }

    public void method_25349(class_11909 click, double distX, double distY) {
        if (this.dragging) {
            double posBefore = this.pos;
            this.pos = this.horizontal ? Math.min(Math.max(this.pos + distX / (double)(this.length - this.barLength), 0.0), 1.0) : Math.min(Math.max(this.pos + distY / (double)(this.length - this.barLength), 0.0), 1.0);
            if (this.changedListener != null && Math.abs(posBefore - this.pos) > 0.0) {
                this.changedListener.accept(this.pos);
            }
        }
    }

    public void setScale(double newScale) {
        this.scale = Math.max(newScale, 1.0);
        this.barLength = (int)((double)this.length / Math.min(this.scale, 8.0));
        this.barRepeatLength = this.barLength - 256;
    }

    public void updatePos(double newPos) {
        this.pos = Math.max(Math.min(newPos, 1.0), 0.0);
    }

    public double getPos() {
        return this.pos;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25400(class_11905 input) {
        return super.method_25400(input);
    }

    public void method_47399(class_6382 builder) {
    }
}

