/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui.screen;

import bettercommandblockui.main.BetterCommandBlockUI;
import bettercommandblockui.main.ChainHandler;
import bettercommandblockui.main.ui.CyclingTexturedButtonWidget;
import bettercommandblockui.main.ui.MultiLineTextFieldWidget;
import bettercommandblockui.main.ui.screen.AbstractBetterCommandBlockScreen;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1268;
import net.minecraft.class_1918;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2593;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2870;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8021;
import net.minecraft.class_8666;

@Environment(value=EnvType.CLIENT)
public class BetterCommandBlockScreen
extends AbstractBetterCommandBlockScreen {
    private CyclingTexturedButtonWidget<class_2593.class_2594> modeButton;
    private CyclingTexturedButtonWidget<Boolean> conditionalModeButton;
    private CyclingTexturedButtonWidget<Boolean> redstoneTriggerButton;
    private class_2593.class_2594 mode = class_2593.class_2594.field_11924;
    private class_2680 blockState;
    private ChainHandler chainHandler;
    private class_4185 chainNext;
    private List<class_4185> chainPrior;
    class_2593 blockEntity;
    private boolean conditional;
    private boolean autoActivate;
    public static BetterCommandBlockScreen instance;

    public BetterCommandBlockScreen(class_310 client, class_2593 blockEntity, class_1918 commandExecutor) {
        this.blockEntity = blockEntity;
        this.commandExecutor = commandExecutor;
        this.field_22787 = client;
        this.chainHandler = new ChainHandler(this, this.commandExecutor);
        this.chainPrior = new LinkedList<class_4185>();
        instance = this;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int textBoxWidth = this.field_22789 - (2 * screenMarginX + 2 * cycleButtonWidth + 2 * buttonMargin);
        int sideButtonX = this.field_22789 / 2 - (cycleButtonWidth + buttonMargin + textBoxWidth / 2);
        class_2561[] modeTooltips = new class_2561[]{class_2561.method_43471((String)"advMode.mode.redstone"), class_2561.method_43471((String)"advMode.mode.sequence"), class_2561.method_43471((String)"advMode.mode.auto")};
        this.modeButton = (CyclingTexturedButtonWidget)this.method_37063((class_364)new CyclingTexturedButtonWidget<class_2593.class_2594>(sideButtonX, this.field_22790 / 2 - (buttonHeight + buttonHeight / 2 + buttonMargin), cycleButtonWidth, buttonHeight, class_2561.method_30163((String)""), button -> {
            this.mode = (class_2593.class_2594)button.getValue();
        }, this.field_22787.field_1755, new class_8666[]{BetterCommandBlockUI.BUTTON_IMPULSE, BetterCommandBlockUI.BUTTON_CHAIN, BetterCommandBlockUI.BUTTON_REPEAT}, 0, new class_2593.class_2594[]{class_2593.class_2594.field_11924, class_2593.class_2594.field_11922, class_2593.class_2594.field_11923}, modeTooltips));
        class_2561[] conditionalTooltips = new class_2561[]{class_2561.method_43471((String)"advMode.mode.unconditional"), class_2561.method_43471((String)"advMode.mode.conditional")};
        this.conditionalModeButton = (CyclingTexturedButtonWidget)this.method_37063((class_364)new CyclingTexturedButtonWidget<Boolean>(sideButtonX, this.field_22790 / 2 - buttonHeight / 2, cycleButtonWidth, buttonHeight, class_2561.method_30163((String)""), button -> {
            this.conditional = (Boolean)button.getValue();
        }, this.field_22787.field_1755, new class_8666[]{BetterCommandBlockUI.BUTTON_UNCONDITIONAL, BetterCommandBlockUI.BUTTON_CONDITIONAL}, 0, new Boolean[]{false, true}, conditionalTooltips));
        class_2561[] activeTooltips = new class_2561[]{class_2561.method_43471((String)"advMode.mode.redstoneTriggered"), class_2561.method_43471((String)"advMode.mode.autoexec.bat")};
        this.redstoneTriggerButton = (CyclingTexturedButtonWidget)this.method_37063((class_364)new CyclingTexturedButtonWidget<Boolean>(sideButtonX, this.field_22790 / 2 + buttonHeight / 2 + buttonMargin, cycleButtonWidth, buttonHeight, class_2561.method_30163((String)""), button -> {
            this.autoActivate = (Boolean)button.getValue();
        }, this.field_22787.field_1755, new class_8666[]{BetterCommandBlockUI.BUTTON_POWER_INACTIVE, BetterCommandBlockUI.BUTTON_POWER_ACTIVE}, 0, new Boolean[]{false, true}, activeTooltips));
        if (this.chainHandler.isInChain()) {
            class_2680 next = this.chainHandler.getNext();
            List<class_3545<class_2680, class_2350>> prior = this.chainHandler.getPrior();
            class_2338 position = class_2338.method_49638((class_2374)this.commandExecutor.method_8300());
            this.blockState = class_310.method_1551().field_1687.method_8320(position);
            if (next != null && next.method_26204().equals(class_7923.field_41175.method_63535(class_2960.method_60655((String)"minecraft", (String)"chain_command_block")))) {
                class_2350 dir = (class_2350)class_310.method_1551().field_1687.method_8320(position).method_11654((class_2769)class_2288.field_10791);
                this.chainNext = (class_4185)this.method_37063((class_364)new class_344(49, 5, 20, 20, BetterCommandBlockUI.BlockStateToButtonTextures(next), button -> this.moveAlongChain(dir), class_2561.method_30163((String)"")));
                this.chainNext.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"bcbui.chain.next")));
            }
            if (!prior.isEmpty()) {
                int y = 5;
                for (class_3545<class_2680, class_2350> entry : prior) {
                    this.chainPrior.add((class_4185)this.method_37063((class_364)new class_344(5, y, 20, 20, BetterCommandBlockUI.BlockStateToButtonTextures((class_2680)entry.method_15442()), button -> this.moveAlongChain((class_2350)entry.method_15441()), class_2561.method_30163((String)""))));
                    this.chainPrior.get(this.chainPrior.size() - 1).method_47400(class_7919.method_47407((class_2561)BetterCommandBlockUI.DirectionToText((class_2350)entry.method_15441())));
                    y += 22;
                }
            }
        }
        this.setButtonsActive(false);
    }

    @Override
    protected void setButtonsActive(boolean value) {
        super.setButtonsActive(value);
        this.modeButton.setActive(value);
        this.conditionalModeButton.setActive(value);
        this.redstoneTriggerButton.setActive(value);
    }

    public void moveAlongChain(class_2350 dir) {
        if (this.wasModified() && BetterCommandBlockUI.AUTOSAVE) {
            this.commit();
        }
        class_2338 position = class_2338.method_49638((class_2374)this.commandExecutor.method_8300());
        assert (class_310.method_1551().field_1761 != null);
        class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_1268.field_5808, new class_3965(position.method_10081(dir.method_62675()).method_46558(), class_2350.field_11036, position.method_10081(dir.method_62675()), false));
    }

    @Override
    protected boolean wasModified() {
        boolean bl = super.wasModified();
        return bl || this.modeButton.getValue() != this.priorState.type || this.conditionalModeButton.getValue() != this.priorState.conditional || this.redstoneTriggerButton.getValue() != this.priorState.needsRedstone;
    }

    @Override
    public void returnFromConfig() {
        this.updateCommandBlock();
        super.returnFromConfig();
    }

    public void updateCommandBlock() {
        this.updated = true;
        class_1918 commandBlockExecutor = this.blockEntity.method_11040();
        ((MultiLineTextFieldWidget)this.consoleCommandTextField).setRawText(commandBlockExecutor.method_8289());
        this.trackOutput = commandBlockExecutor.method_8296();
        this.mode = this.blockEntity.method_11039();
        this.conditional = this.blockEntity.method_11046();
        this.autoActivate = this.blockEntity.method_11042();
        this.priorState = new AbstractBetterCommandBlockScreen.CommandBlockState(this.mode, this.conditional, this.autoActivate, this.trackOutput);
        if (!BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_USED) {
            int trackingOutputIndex = this.trackOutput ? 0 : 1;
            this.toggleTrackingOutputButton.setIndex(trackingOutputIndex);
        }
        int modeIndex = 0;
        this.mode = this.blockEntity.method_11039();
        switch (this.mode) {
            case field_11922: {
                modeIndex = 1;
                break;
            }
            case field_11923: {
                modeIndex = 2;
            }
        }
        this.modeButton.setIndex(modeIndex);
        int conditionalIndex = this.conditional ? 1 : 0;
        this.conditionalModeButton.setIndex(conditionalIndex);
        int autoIndex = this.autoActivate ? 1 : 0;
        this.redstoneTriggerButton.setIndex(autoIndex);
        this.setPreviousOutputText(this.trackOutput);
        this.setButtonsActive(true);
    }

    @Override
    protected void commit() {
        super.commit();
        this.priorState.needsRedstone = this.redstoneTriggerButton.getValue();
        this.priorState.type = this.modeButton.getValue();
        this.priorState.conditional = this.conditional;
    }

    @Override
    protected void syncSettingsToServer(class_1918 commandExecutor) {
        assert (this.field_22787 != null);
        Objects.requireNonNull(this.field_22787.method_1562()).method_52787((class_2596)new class_2870(class_2338.method_49638((class_2374)commandExecutor.method_8300()), this.consoleCommandTextField.method_1882(), this.mode, this.trackOutput, this.conditional, this.autoActivate));
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderAsterisk(context, (class_8021)this.modeButton, this.modeButton.getValue() != this.priorState.type);
        this.renderAsterisk(context, (class_8021)this.conditionalModeButton, this.conditionalModeButton.getValue() != this.priorState.conditional);
        this.renderAsterisk(context, (class_8021)this.redstoneTriggerButton, this.redstoneTriggerButton.getValue() != this.priorState.needsRedstone);
        if (this.chainHandler.isInChain()) {
            class_2960 texture = BetterCommandBlockUI.BlockStateToButtonTextures(this.blockState).comp_1604();
            context.method_52706(class_10799.field_56883, texture, 27, 5, 20, 20);
            context.method_25294(27, 5, 46, 24, -1895825408);
            this.renderAsterisk(context, 47, 1, this.wasModified());
            if (!this.updated) {
                if (this.showOutput) {
                    context.method_25294(this.previousOutputTextField.method_46426(), this.previousOutputTextField.method_46427(), this.previousOutputTextField.method_46426() + this.previousOutputTextField.method_25368(), this.previousOutputTextField.method_46427() + this.previousOutputTextField.method_25364(), -1895825408);
                } else {
                    context.method_25294(this.consoleCommandTextField.method_46426(), this.consoleCommandTextField.method_46427(), this.consoleCommandTextField.method_46426() + this.consoleCommandTextField.method_25368(), this.consoleCommandTextField.method_46427() + this.consoleCommandTextField.method_25364(), -1895825408);
                }
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"bcbui.chain.tooFar"), this.field_22789 / 2, this.field_22790 / 2, -6250336);
            }
        }
    }
}

