/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.config;

import dev.obscuria.fragmentum.config.ConfigLayout;
import dev.obscuria.fragmentum.config.ConfigOptions;
import dev.obscuria.fragmentum.config.ConfigRegistry;

public final class CaravanConfig {
    public static final Layout common = new Layout();

    public static void init() {
        String fileName = "obscuria/pillager_caravans-common.toml";
        ConfigRegistry.registerCommon((String)"caravans", (String)"obscuria/pillager_caravans-common.toml", (ConfigLayout)common, CaravanConfig::update);
    }

    private static void update(Layout layout) {
    }

    public static class Layout
    implements ConfigLayout {
        @ConfigOptions.Value(value="showEncounterToast")
        @ConfigOptions.Comment(value="Whether to show a toast when a player encounters a caravan.")
        public boolean showEncounterToast = true;
        @ConfigOptions.Value(value="toastLightMode")
        @ConfigOptions.Comment(value="Whether to use light mode for the toast.")
        public boolean toastLightMode = false;
        @ConfigOptions.Section(value="Spawning")
        public final Spawning spawning = new Spawning();

        public static final class Spawning {
            @ConfigOptions.Value(value="worldAgeRequired")
            @ConfigOptions.Range(min=0.0)
            @ConfigOptions.Comment(value="Minimum world age in ticks required before caravans can start spawning.//24000 ticks = 1 Minecraft day.")
            public int worldAgeRequired = 24000;
            @ConfigOptions.Value(value="cooldownMultiplier")
            @ConfigOptions.Range(min=0.1, max=100.0)
            @ConfigOptions.Comment(value="Additional multiplier applied to the base cooldowns defined in the datapack.//Larger caravans usually have longer cooldowns after spawning.//This value scales all existing cooldowns globally (1.0 = 100%).")
            public double cooldownMultiplier = 1.0;
            @ConfigOptions.Value(value="failedCooldown")
            @ConfigOptions.Range(min=200.0)
            @ConfigOptions.Comment(value="Cooldown in ticks after a failed caravan spawn attempt before trying again.")
            public int failedCooldown = 1200;
            @ConfigOptions.Value(value="distance")
            @ConfigOptions.Range(min=8.0, max=256.0)
            @ConfigOptions.Comment(value="Base distance from the player where caravans will spawn.")
            public int distance = 32;
            @ConfigOptions.Value(value="distanceVariance")
            @ConfigOptions.Range(min=0.0, max=256.0)
            @ConfigOptions.Comment(value="Random variance added to the base spawn distance (0~value).")
            public int distanceVariance = 32;
        }
    }
}

