/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import dev.obscuria.caravans.PillagerCaravans;
import dev.obscuria.caravans.config.CaravanConfig;
import dev.obscuria.caravans.content.IWeighted;
import dev.obscuria.caravans.content.caravan.CaravanPlacement;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5304;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class CaravanSpawner
implements class_5304 {
    public static final CaravanSpawner INSTANCE = new CaravanSpawner();
    public int cooldownTick = 12000;

    public int method_6445(class_3218 level, boolean spawnHostile, boolean spawnFriendly) {
        if (!this.shouldSpawn(level, spawnHostile)) {
            return 0;
        }
        class_3222 player = this.selectPlayer(level);
        if (player == null) {
            return 0;
        }
        class_2338.class_2339 pos = this.selectPosition(level, player);
        if (pos == null) {
            return 0;
        }
        class_6880<CaravanVariation> caravan = this.selectCaravan(level, (class_2338)pos);
        if (caravan == null) {
            return 0;
        }
        int totalSpawned = ((CaravanVariation)caravan.comp_349()).spawn(caravan, level, (class_2338)pos);
        if (totalSpawned <= 0) {
            return 0;
        }
        this.cooldownTick = ((CaravanVariation)caravan.comp_349()).actualCooldown();
        return totalSpawned;
    }

    private boolean shouldSpawn(class_3218 level, boolean spawnHostile) {
        if (!spawnHostile || !level.method_8450().method_8355(PillagerCaravans.RULE_DO_CARAVAN_SPAWNING)) {
            return false;
        }
        if (--this.cooldownTick > 0) {
            return false;
        }
        this.cooldownTick = CaravanConfig.common.spawning.failedCooldown;
        return level.method_8532() / (long)CaravanConfig.common.spawning.worldAgeRequired >= 1L;
    }

    @Nullable
    private class_3222 selectPlayer(class_3218 level) {
        int players = level.method_18456().size();
        if (players < 1) {
            return null;
        }
        class_3222 player = (class_3222)level.method_18456().get(level.field_9229.method_43048(players));
        if (player.method_7325()) {
            return null;
        }
        if (level.method_19497(player.method_24515(), 2)) {
            return null;
        }
        return player;
    }

    @Nullable
    private class_2338.class_2339 selectPosition(class_3218 level, class_3222 player) {
        class_5819 random = level.field_9229;
        int distance = CaravanConfig.common.spawning.distance;
        int variance = CaravanConfig.common.spawning.distanceVariance;
        int xOffset = (distance + random.method_43048(variance)) * (random.method_43056() ? -1 : 1);
        int yOffset = (distance + random.method_43048(variance)) * (random.method_43056() ? -1 : 1);
        class_2338.class_2339 pos = player.method_24515().method_25503().method_10100(xOffset, 0, yOffset);
        if (!level.method_33597(pos.method_10263() - 10, pos.method_10260() - 10, pos.method_10263() + 10, pos.method_10260() + 10)) {
            return null;
        }
        return pos;
    }

    @Nullable
    private class_6880<CaravanVariation> selectCaravan(class_3218 level, class_2338 pos) {
        class_2378 registry = level.method_30349().method_30530(CaravanRegistries.Keys.PLACEMENT);
        class_6880 biome = level.method_23753(pos);
        List<CaravanPlacement> candidates = registry.method_10220().filter(it -> it.isFor((class_6880<class_1959>)biome)).toList();
        CaravanPlacement placement = IWeighted.pickRandom(candidates, level.field_9229);
        return placement == null ? null : placement.getRandomVariation(level.field_9229);
    }
}

