/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.client;

import dev.obscuria.caravans.config.CaravanConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public record CaravanEncounterToast(ResourceLocation caravanType) implements Toast
{
    private static final ResourceLocation DARK_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final ResourceLocation LIGHT_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final int DISPLAY_TIME = 5000;
    private static final ItemStack ICON = Items.CROSSBOW.getDefaultInstance();
    private static final Component TITLE = Component.translatable((String)"toast.caravans.encounter");

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent component, long timeSinceLastVisible) {
        Boolean lightMode = (Boolean)CaravanConfig.TOAST_LIGHT_MODE.get();
        graphics.blitSprite(lightMode != false ? LIGHT_SPRITE : DARK_SPRITE, 0, 0, this.width(), this.height());
        MutableComponent caravanName = Component.translatable((String)this.caravanType.toLanguageKey("caravan"));
        graphics.drawString(component.getMinecraft().font, TITLE, 30, 7, lightMode != false ? 0xAA00AA : 0xFFAA00, false);
        graphics.drawString(component.getMinecraft().font, (Component)caravanName, 30, 18, lightMode != false ? -16777216 : -1, false);
        graphics.renderFakeItem(ICON, 8, 8);
        double displayTime = (double)DISPLAY_TIME * component.getNotificationDisplayTimeMultiplier();
        return (double)timeSinceLastVisible >= displayTime ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

