/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content;

import com.google.common.collect.ImmutableList;
import dev.obscuria.caravans.config.CaravanConfig;
import dev.obscuria.caravans.content.ILivingExtension;
import dev.obscuria.caravans.content.caravan.CaravanSpawner;
import dev.obscuria.caravans.content.network.ClientboundEncounterPayload;
import dev.obscuria.fragmentum.content.network.FragmentumNetworking;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CustomSpawner;

public interface Hooks {
    public static ImmutableList<CustomSpawner> injectSpawners(List<CustomSpawner> spawners) {
        return ImmutableList.builder().addAll(spawners).add((Object)CaravanSpawner.INSTANCE).build();
    }

    public static void onLivingTick(LivingEntity entity) {
        if (!((Boolean)CaravanConfig.SHOW_ENCOUNTER_TOAST.get()).booleanValue()) {
            return;
        }
        if (entity.level().isClientSide()) {
            return;
        }
        if (entity.tickCount % 40 != 0) {
            return;
        }
        ResourceLocation caravanType = ILivingExtension.getCaravanType(entity);
        if (caravanType == null) {
            return;
        }
        List<UUID> playerTracker = ILivingExtension.playerTracker(entity);
        List players = entity.level().getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(32.0));
        if (players.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            if (playerTracker.contains(player.getUUID())) continue;
            FragmentumNetworking.sendTo((ServerPlayer)player, (CustomPacketPayload)ClientboundEncounterPayload.forCaravan(caravanType));
            playerTracker.add(player.getUUID());
        }
    }

    public static void onLeashTick(Entity entity) {
        LivingEntity living;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Entity holder = mob.getLeashHolder();
        if (holder == null || !holder.isRemoved()) {
            return;
        }
        if (holder.getRemovalReason() != Entity.RemovalReason.DISCARDED) {
            return;
        }
        if (!(holder instanceof LivingEntity) || !ILivingExtension.isCaravanMember(living = (LivingEntity)holder)) {
            return;
        }
        mob.dropLeash(false, false);
        mob.discard();
    }
}

