/*
 * Decompiled with CFR 0.152.
 */
package com.entropy.tacz_turrets.common.entity;

import com.entropy.tacz_turrets.TACZTurretsConfig;
import com.entropy.tacz_turrets.common.entity.TaczShootAttack;
import com.entropy.tacz_turrets.common.registry.ItemRegistry;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.entity.shooter.LivingEntityAim;
import com.tacz.guns.entity.shooter.LivingEntityAmmoCheck;
import com.tacz.guns.entity.shooter.LivingEntityBolt;
import com.tacz.guns.entity.shooter.LivingEntityCrawl;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityFireSelect;
import com.tacz.guns.entity.shooter.LivingEntityMelee;
import com.tacz.guns.entity.shooter.LivingEntityReload;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.LivingEntitySpeedModifier;
import com.tacz.guns.entity.shooter.LivingEntitySprint;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.entity.sync.ModSyncedEntityData;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.item.AmmoItem;
import com.tacz.guns.item.ModernKineticGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TurretEntity
extends Mob
implements SmartBrainOwner<TurretEntity>,
IGunOperator,
IItemHandler,
GeoEntity,
ICapabilityProvider {
    public static final EntityType<TurretEntity> TYPE = EntityType.Builder.m_20704_(TurretEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("turret");
    private LivingEntity currentAngerTarget;
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);
    private boolean angry = false;
    public int rangedCooldown = 0;
    public boolean firing = true;
    public int collectiveShots = 0;
    public boolean isReloading = false;
    public long shootTimestamp = 0L;
    public List<LivingEntity> attackers = new ArrayList<LivingEntity>();
    private final LivingEntity tacz$shooter = this;
    public final ShooterDataHolder tacz$data = new ShooterDataHolder();
    private final LivingEntityDrawGun tacz$draw;
    private final LivingEntityAim tacz$aim;
    private final LivingEntityCrawl tacz$crawl;
    private final LivingEntityAmmoCheck tacz$ammoCheck;
    private final LivingEntityFireSelect tacz$fireSelect;
    private final LivingEntityMelee tacz$melee;
    private final LivingEntityShoot tacz$shoot;
    private final LivingEntityBolt tacz$bolt;
    private final LivingEntityReload tacz$reload;
    private final LivingEntitySpeedModifier tacz$speed;
    private final LivingEntitySprint tacz$sprint;
    private boolean drawn = false;
    private final ItemStackHandler inventory = new ItemStackHandler(5);
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);
    public UUID owner;
    public static final EntityDataAccessor<String> stateName = SynchedEntityData.m_135353_(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TurretEntity(Level level, BlockPos pos, Player player) {
        this(TYPE, level);
        this.m_146884_(pos.m_252807_());
        this.owner = player.m_20148_();
    }

    public TurretEntity(EntityType<? extends TurretEntity> type, Level level) {
        super(type, level);
        this.initialData();
        this.tacz$draw = new LivingEntityDrawGun(this.tacz$shooter, this.tacz$data);
        this.tacz$aim = new LivingEntityAim(this.tacz$shooter, this.tacz$data);
        this.tacz$crawl = new LivingEntityCrawl(this.tacz$shooter, this.tacz$data);
        this.tacz$ammoCheck = new LivingEntityAmmoCheck(this.tacz$shooter);
        this.tacz$fireSelect = new LivingEntityFireSelect(this.tacz$shooter, this.tacz$data);
        this.tacz$melee = new LivingEntityMelee(this.tacz$shooter, this.tacz$data, this.tacz$draw);
        this.tacz$shoot = new LivingEntityShoot(this.tacz$shooter, this.tacz$data, this.tacz$draw);
        this.tacz$bolt = new LivingEntityBolt(this.tacz$data, this.tacz$shooter, this.tacz$draw, this.tacz$shoot);
        this.tacz$reload = new LivingEntityReload(this.tacz$shooter, this.tacz$data, this.tacz$draw, this.tacz$shoot);
        this.tacz$speed = new LivingEntitySpeedModifier(this.tacz$shooter, this.tacz$data);
        this.tacz$sprint = new LivingEntitySprint(this.tacz$shooter, this.tacz$data);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(stateName, (Object)"No Gun");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21183_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22276_, 200.0);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof TurretEntity) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2;
            this.currentAngerTarget = entity2 = (LivingEntity)entity;
            List entities = this.m_9236_().m_45976_(TurretEntity.class, AABB.m_165882_((Vec3)this.m_20182_(), (double)64.0, (double)16.0, (double)64.0));
            List<TurretEntity> filter1 = entities.stream().filter(e -> e.m_142582_((Entity)this.currentAngerTarget) || BehaviorUtils.m_22636_((Brain)e.m_6274_(), (LivingEntity)this.currentAngerTarget)).toList();
            for (TurretEntity duty : filter1) {
                duty.m_6710_(this.currentAngerTarget);
                duty.currentAngerTarget = entity2;
                duty.f_20939_.m_21879_(MemoryModuleType.f_26372_, (Object)this.currentAngerTarget);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        pCompound.m_128362_("Owner", this.owner);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.inventory.deserializeNBT(pCompound.m_128469_("Inventory"));
        this.owner = pCompound.m_128342_("Owner");
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
            this.m_19983_(this.inventory.extractItem(i, this.inventory.getStackInSlot(i).m_41613_(), false));
        }
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            ItemStack itemstack = this.m_6844_(equipmentslot);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41763_()) {
                itemstack.m_41721_(itemstack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemstack.m_41776_() - 3, 1))));
            }
            this.m_19983_(itemstack);
            this.m_8061_(equipmentslot, ItemStack.f_41583_);
        }
    }

    public BrainActivityGroup<? extends TurretEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new Idle().runFor(entity -> RandomSource.m_216327_().m_216339_(30, 60))});
    }

    public BrainActivityGroup<? extends TurretEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetRetaliateTarget(), new TaczShootAttack(32).startCondition(x$0 -> this.m_21205_().m_150930_((Item)ModItems.MODERN_KINETIC_GUN.get()) && this.collectiveShots <= this.getStateBurst())});
    }

    public List<? extends ExtendedSensor<? extends TurretEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyPlayersSensor().setPredicate((p, e) -> e.attackers.contains(p)), new HurtBySensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> target == this.currentAngerTarget || target instanceof Monster || target.m_6095_().m_20674_() == MobCategory.MONSTER)});
    }

    public GunTabType heldGunType() {
        ModernKineticGunItem gun;
        Object object = this.m_21205_().m_41720_();
        if (object instanceof ModernKineticGunItem && TimelessAPI.getCommonGunIndex((ResourceLocation)(gun = (ModernKineticGunItem)object).getGunId(this.m_21205_())).isPresent()) {
            return switch (((CommonGunIndex)TimelessAPI.getCommonGunIndex((ResourceLocation)gun.getGunId(this.m_21205_())).get()).getType()) {
                case "pistol" -> GunTabType.PISTOL;
                case "rifle" -> GunTabType.RIFLE;
                case "sniper" -> GunTabType.SNIPER;
                case "smg" -> GunTabType.SMG;
                case "rpg" -> GunTabType.RPG;
                case "shotgun" -> GunTabType.SHOTGUN;
                case "mg" -> GunTabType.MG;
                default -> throw new IllegalStateException("Unexpected value: " + ((CommonGunIndex)TimelessAPI.getCommonGunIndex((ResourceLocation)gun.getGunId(this.m_21205_())).get()).getType());
            };
        }
        return GunTabType.PISTOL;
    }

    public int getStateRangedCooldown() {
        if (this.heldGunType() != null) {
            return switch (this.heldGunType()) {
                default -> throw new IncompatibleClassChangeError();
                case GunTabType.RIFLE -> 10;
                case GunTabType.PISTOL -> 8;
                case GunTabType.SNIPER -> 30;
                case GunTabType.SHOTGUN -> 20;
                case GunTabType.SMG, GunTabType.MG -> 5;
                case GunTabType.RPG -> 100;
            };
        }
        return 60;
    }

    int getStateBurst() {
        if (this.heldGunType() != null) {
            return switch (this.heldGunType()) {
                default -> throw new IncompatibleClassChangeError();
                case GunTabType.RIFLE -> 2;
                case GunTabType.PISTOL -> 3;
                case GunTabType.SNIPER, GunTabType.SHOTGUN, GunTabType.RPG -> 1;
                case GunTabType.SMG, GunTabType.MG -> 4;
            };
        }
        return 1;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    public void m_7581_(@NotNull ItemEntity pItemEntity) {
        ItemStack itemstack;
        if (!this.m_21224_() && this.m_7243_(itemstack = pItemEntity.m_32055_())) {
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                if (!this.inventory.getStackInSlot(slot).m_41619_() && (!this.inventory.getStackInSlot(slot).m_150930_(itemstack.m_41720_()) || !itemstack.m_150930_((Item)ModItems.AMMO.get()))) continue;
                if (slot == 0) {
                    if (!itemstack.m_150930_((Item)ModItems.MODERN_KINETIC_GUN.get())) continue;
                    this.m_21053_(pItemEntity);
                    this.m_21468_(EquipmentSlot.MAINHAND, itemstack);
                    this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
                    pItemEntity.m_146870_();
                    return;
                }
                this.m_21053_(pItemEntity);
                int count = Math.min(itemstack.m_41613_(), this.inventory.getStackInSlot(slot).m_41741_() - this.inventory.getStackInSlot(slot).m_41613_());
                this.inventory.setStackInSlot(slot, itemstack.m_255036_(count + this.inventory.getStackInSlot(slot).m_41613_()));
                if (count >= itemstack.m_41613_()) {
                    this.m_7938_((Entity)pItemEntity, count);
                    pItemEntity.m_146870_();
                    return;
                }
                if (count <= 0) continue;
                this.m_7938_((Entity)pItemEntity, count);
                pItemEntity.m_32045_(itemstack.m_255036_(itemstack.m_41613_() - count));
                itemstack = pItemEntity.m_32055_();
            }
        }
    }

    public void m_8119_() {
        List items;
        if (this.m_5448_() == null && this.angry) {
            this.angry = false;
        }
        if (this.currentAngerTarget != null && !this.currentAngerTarget.m_6084_()) {
            this.currentAngerTarget = null;
        }
        this.onTickServerSide();
        Item item = this.m_21205_().m_41720_();
        if (item instanceof ModernKineticGunItem) {
            ModernKineticGunItem gun = (ModernKineticGunItem)item;
            if (this.m_21205_().m_41784_().m_128451_("GunCurrentAmmoCount") == 0 && !this.m_21205_().m_41784_().m_128471_("HasBulletInBarrel")) {
                this.reload();
            }
            if (gun.getCurrentAmmoCount(this.m_21205_()) > 0) {
                this.isReloading = false;
            } else {
                if (!this.isReloading) {
                    this.reload();
                }
                this.isReloading = true;
            }
        }
        if (this.firing && this.shootTimestamp != 0L && (System.currentTimeMillis() - this.shootTimestamp) / 100L > (long)this.getStateRangedCooldown()) {
            this.collectiveShots = 0;
            this.shootTimestamp = 0L;
            this.firing = false;
            this.aim(false);
        }
        if (this.rangedCooldown != 0) {
            --this.rangedCooldown;
        }
        if (!(items = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(1.1))).isEmpty() && !this.m_9236_().m_5776_()) {
            for (ItemEntity item2 : items) {
                AmmoItem ammo;
                Item item3;
                if ((!(item2.m_32055_().m_41720_() instanceof ModernKineticGunItem) || !this.m_21205_().m_41619_()) && (!((item3 = item2.m_32055_().m_41720_()) instanceof AmmoItem) || !(ammo = (AmmoItem)item3).isAmmoOfGun(this.m_21205_(), item2.m_32055_()) || !TACZTurretsConfig.consumeAmmo)) continue;
                this.m_7581_(item2);
            }
        }
        super.m_8119_();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player.m_20148_() != this.owner) {
            return super.m_6071_(player, hand);
        }
        if (!this.m_21205_().m_41619_() || player.m_6047_()) {
            player.m_150109_().m_36054_(this.m_21205_());
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                if (this.inventory.getStackInSlot(slot).m_41619_()) continue;
                player.m_150109_().m_36054_(this.inventory.extractItem(slot, this.inventory.getStackInSlot(slot).m_41613_(), false));
            }
            if (player.m_6047_()) {
                if (!player.m_7500_()) {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)ItemRegistry.TURRET.get()));
                }
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_150930_((Item)ModItems.MODERN_KINETIC_GUN.get())) {
            this.m_21008_(InteractionHand.MAIN_HAND, player.m_21120_(hand));
            player.m_21008_(hand, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void draw(Supplier<ItemStack> gunItemSupplier) {
        this.tacz$draw.draw(gunItemSupplier);
        this.drawn = true;
    }

    public void reload() {
        this.tacz$reload.reload();
        this.isReloading = true;
    }

    public void aim(boolean isAim) {
        this.tacz$aim.aim(isAim);
    }

    public void crawl(boolean isCrawl) {
        this.tacz$crawl.crawl(isCrawl);
    }

    public void updateCacheProperty(AttachmentCacheProperty cacheProperty) {
        this.tacz$data.cacheProperty = cacheProperty;
    }

    @Nullable
    public AttachmentCacheProperty getCacheProperty() {
        return this.tacz$data.cacheProperty;
    }

    public void fireSelect() {
        this.tacz$fireSelect.fireSelect();
    }

    public void zoom() {
        this.tacz$aim.zoom();
    }

    public long getSynShootCoolDown() {
        return (Long)ModSyncedEntityData.SHOOT_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public long getSynMeleeCoolDown() {
        return (Long)ModSyncedEntityData.MELEE_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public long getSynDrawCoolDown() {
        return (Long)ModSyncedEntityData.DRAW_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public boolean getSynIsBolting() {
        return (Boolean)ModSyncedEntityData.IS_BOLTING_KEY.getValue((Entity)this.tacz$shooter);
    }

    public ReloadState getSynReloadState() {
        return (ReloadState)ModSyncedEntityData.RELOAD_STATE_KEY.getValue((Entity)this.tacz$shooter);
    }

    public float getSynAimingProgress() {
        return ((Float)ModSyncedEntityData.AIMING_PROGRESS_KEY.getValue((Entity)this.tacz$shooter)).floatValue();
    }

    public float getSynSprintTime() {
        return ((Float)ModSyncedEntityData.SPRINT_TIME_KEY.getValue((Entity)this.tacz$shooter)).floatValue();
    }

    public boolean getSynIsAiming() {
        return (Boolean)ModSyncedEntityData.IS_AIMING_KEY.getValue((Entity)this.tacz$shooter);
    }

    public void initialData() {
        this.tacz$data.initialData();
        AttachmentPropertyManager.postChangeEvent((LivingEntity)this.tacz$shooter, (ItemStack)this.tacz$shooter.m_21205_());
    }

    public void bolt() {
        this.tacz$bolt.bolt();
    }

    public void cancelReload() {
        this.tacz$reload.cancelReload();
    }

    public void melee() {
        this.tacz$melee.melee();
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw) {
        return this.shoot(pitch, yaw, System.currentTimeMillis() - this.tacz$data.baseTimestamp);
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw, long timestamp) {
        this.shootTimestamp = System.currentTimeMillis();
        return this.tacz$shoot.shoot(pitch, yaw, timestamp);
    }

    public boolean needCheckAmmo() {
        return TACZTurretsConfig.consumeAmmo;
    }

    public boolean consumesAmmoOrNot() {
        return this.tacz$ammoCheck.consumesAmmoOrNot();
    }

    @Unique
    public boolean getProcessedSprintStatus(boolean sprint) {
        return this.tacz$sprint.getProcessedSprintStatus(sprint);
    }

    public ShooterDataHolder getDataHolder() {
        return this.tacz$data;
    }

    public boolean nextBulletIsTracer(int tracerCountInterval) {
        ++this.tacz$data.shootCount;
        return true;
    }

    private void onTickServerSide() {
        if (!this.m_9236_().m_5776_()) {
            boolean hasAmmo;
            Item item = this.m_21205_().m_41720_();
            if (item instanceof ModernKineticGunItem) {
                Optional gunIndexOptional;
                ModernKineticGunItem gun = (ModernKineticGunItem)item;
                if (!this.drawn) {
                    this.draw(() -> ((TurretEntity)this).m_21205_());
                }
                ItemStack gunItem = this.m_21205_();
                ResourceLocation gunId = gun.getGunId(gunItem);
                IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
                if (iGun != null && (gunIndexOptional = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId)).isPresent()) {
                    CommonGunIndex gunIndex = (CommonGunIndex)gunIndexOptional.get();
                    GunData gunData = gunIndex.getGunData();
                    AttachmentCacheProperty property = new AttachmentCacheProperty();
                    property.eval(this.m_21205_(), gunData);
                    this.updateCacheProperty(property);
                }
            }
            this.bolt();
            ReloadState reloadState = this.tacz$reload.tickReloadState();
            this.tacz$aim.tickAimingProgress();
            this.tacz$aim.tickSprint();
            this.tacz$crawl.tickCrawling();
            this.tacz$bolt.tickBolt();
            this.tacz$melee.scheduleTickMelee();
            this.tacz$speed.updateSpeedModifier();
            this.tacz$shooter.m_6858_(this.getProcessedSprintStatus(this.tacz$shooter.m_20142_()));
            ModSyncedEntityData.SHOOT_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$shoot.getShootCoolDown());
            ModSyncedEntityData.MELEE_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$melee.getMeleeCoolDown());
            ModSyncedEntityData.DRAW_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$draw.getDrawCoolDown());
            ModSyncedEntityData.IS_BOLTING_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$data.isBolting);
            ModSyncedEntityData.RELOAD_STATE_KEY.setValue((Entity)this.tacz$shooter, (Object)reloadState);
            ModSyncedEntityData.AIMING_PROGRESS_KEY.setValue((Entity)this.tacz$shooter, (Object)Float.valueOf(this.tacz$data.aimingProgress));
            ModSyncedEntityData.IS_AIMING_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$data.isAiming);
            ModSyncedEntityData.SPRINT_TIME_KEY.setValue((Entity)this.tacz$shooter, (Object)Float.valueOf(this.tacz$data.sprintTimeS));
            boolean bl = hasAmmo = !TACZTurretsConfig.consumeAmmo;
            if (TACZTurretsConfig.consumeAmmo) {
                BlockEntity blockEntity;
                BlockEntity blockEntity2 = blockEntity = this.m_9236_().m_7702_(this.m_20183_()) == null ? this.m_9236_().m_7702_(this.m_20183_().m_7495_()) : this.m_9236_().m_7702_(this.m_20183_());
                if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().isPresent()) {
                    IItemHandler handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().get();
                    for (int slot = 0; slot < this.getSlots(); ++slot) {
                        IAmmo ammo;
                        for (int s = 0; s < handler.getSlots(); ++s) {
                            ItemStack remainder;
                            IAmmo ammo2;
                            ItemStack stack = handler.getStackInSlot(s);
                            Item item2 = stack.m_41720_();
                            if (!(item2 instanceof IAmmo) || !(ammo2 = (IAmmo)item2).isAmmoOfGun(this.m_21205_(), stack) || this.getStackInSlot(slot).m_41613_() >= this.getStackInSlot(slot).m_41741_() || (remainder = this.insertItem(slot, handler.extractItem(s, stack.m_41613_(), false), false)).m_41619_()) continue;
                            handler.insertItem(s, remainder, false);
                        }
                        Item item3 = this.getStackInSlot(slot).m_41720_();
                        if (!(item3 instanceof IAmmo) || !(ammo = (IAmmo)item3).isAmmoOfGun(this.m_21205_(), this.getStackInSlot(slot))) continue;
                        hasAmmo = true;
                    }
                }
            }
            if (this.m_21205_().m_41784_().m_128451_("GunCurrentAmmoCount") > 0 || this.m_21205_().m_41784_().m_128471_("HasBulletInBarrel")) {
                hasAmmo = true;
            }
            if (this.m_21205_().m_150930_((Item)ModItems.MODERN_KINETIC_GUN.get())) {
                if (reloadState.getStateType() == ReloadState.StateType.NOT_RELOADING) {
                    if (hasAmmo) {
                        TurretState.ACTIVE.setState(this);
                    } else {
                        TurretState.NO_AMMO.setState(this);
                    }
                } else {
                    TurretState.RELOADING.setState(this);
                }
            } else {
                TurretState.NO_GUN.setState(this);
            }
        }
    }

    public void m_6710_(@Nullable LivingEntity pLivingEntity) {
        if (this.m_5448_() == null && pLivingEntity != null) {
            ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
        if (pLivingEntity instanceof Player) {
            this.m_6598_((Player)pLivingEntity);
        }
        super.m_6710_(pLivingEntity);
    }

    public BrainActivityGroup<? extends TurretEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().isAllyIf((e, l) -> l instanceof TurretEntity).attackablePredicate(l -> l != null && this.m_142582_((Entity)l)).alertAlliesWhen((m, e) -> e != null && m.m_142582_(e)).runFor(e -> 999), new LookAtTarget().runFor(entity -> RandomSource.m_216327_().m_216339_(40, 300))});
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.inventory.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.inventory.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.inventory.isItemValid(slot, stack);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    public boolean m_6128_() {
        return true;
    }

    public static enum TurretState {
        ACTIVE("Active"),
        RELOADING("Reloading"),
        NO_AMMO("No Ammo"),
        NO_GUN("No Gun");

        private final String name;
        private final String texture;

        private TurretState(String name) {
            this.name = name;
            this.texture = name.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        }

        public void setState(TurretEntity turret) {
            turret.f_19804_.m_135381_(stateName, (Object)this.name);
        }

        public ResourceLocation getPath() {
            return new ResourceLocation("tacz_turrets", "textures/entity/turret_" + this.texture + ".png");
        }

        public static TurretState getState(TurretEntity turret) {
            for (TurretState state : TurretState.values()) {
                if (!((String)turret.m_20088_().m_135370_(stateName)).equals(state.name)) continue;
                return state;
            }
            return NO_GUN;
        }
    }
}

