/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerGarlandBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN && entry.getKey() != Direction.UP).collect(Util.toMap());
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)9.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public FlowerGarlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), FlowerGarlandBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.hasFaces(this.getUpdatedState(state, (BlockGetter)level, pos));
    }

    private boolean hasFaces(BlockState state) {
        return this.countFaces(state) > 0;
    }

    private int countFaces(BlockState state) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)state.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BlockPos blockpos = pos.relative(direction);
        return FlowerGarlandBlock.isAcceptableNeighbour(level, blockpos, direction);
    }

    public static boolean isAcceptableNeighbour(BlockGetter blockReader, BlockPos neighborPos, Direction attachedFace) {
        BlockState state = blockReader.getBlockState(neighborPos);
        VoxelShape neighborSupportFaceShape = state.getBlockSupportShape(blockReader, neighborPos).getFaceShape(attachedFace.getOpposite());
        VoxelShape neighborCollisionFaceShape = state.getCollisionShape(blockReader, neighborPos).getFaceShape(attachedFace.getOpposite());
        return !Shapes.joinIsNotEmpty((VoxelShape)neighborCollisionFaceShape, (VoxelShape)SUPPORT_SHAPE, (BooleanOp)BooleanOp.ONLY_SECOND) || !Shapes.joinIsNotEmpty((VoxelShape)neighborSupportFaceShape, (VoxelShape)SUPPORT_SHAPE, (BooleanOp)BooleanOp.ONLY_SECOND);
    }

    private BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = FlowerGarlandBlock.getPropertyForFace(direction);
            if (!((Boolean)state.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(level, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = level.getBlockState(blockpos);
                }
                flag = blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            }
            state = (BlockState)state.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        }
        BlockState blockstate = this.getUpdatedState(state, (BlockGetter)level, currentPos);
        return !this.hasFaces(blockstate) ? Blocks.AIR.defaultBlockState() : blockstate;
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        if (!blockPlaceContext.isSecondaryUseActive() && blockPlaceContext.getItemInHand().is(this.asItem())) {
            return this.countFaces(blockState) < PROPERTY_BY_DIRECTION.size();
        }
        return super.canBeReplaced(blockState, blockPlaceContext);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        boolean flag = blockstate.is((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.defaultBlockState();
        for (Direction direction : context.getNearestLookingDirections()) {
            boolean flag1;
            if (direction.getAxis() == Direction.Axis.Y) continue;
            BooleanProperty booleanproperty = FlowerGarlandBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)context.getLevel(), context.getClickedPos(), direction)) continue;
            return (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
        }
        return super.mirror(state, mirror);
    }

    public static BooleanProperty getPropertyForFace(Direction face) {
        return PROPERTY_BY_DIRECTION.get(face);
    }
}

