/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.registry;

import cc.cassian.wilderflowers.WilderFlowers;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CommonRegistry {
    public static <R, T extends R> Supplier<T> register(String name, Supplier<T> supplier, Registry<R> reg) {
        Object object = supplier.get();
        Registry.register(reg, (ResourceLocation)WilderFlowers.locate(name), object);
        return () -> object;
    }

    public static <B extends Item> Supplier<B> registerItem(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.ITEM);
    }

    public static <B extends Block> Supplier<B> registerBlock(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.BLOCK);
    }

    public static <T extends EntityType<?>> Supplier<T> registerEntity(String name, Supplier<T> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.ENTITY_TYPE);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name, Supplier<SoundEvent> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.SOUND_EVENT);
    }

    public static <B extends RecipeSerializer<?>> Supplier<B> registerRecipeSerializer(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.RECIPE_SERIALIZER);
    }

    public static <B extends RecipeType<?>> Supplier<B> registerRecipe(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.RECIPE_TYPE);
    }

    public static <B extends BlockEntityType<?>> Supplier<B> registerBlockEntity(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.BLOCK_ENTITY_TYPE);
    }

    public static Supplier<SimpleParticleType> registerParticleType(String name, Supplier<SimpleParticleType> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.PARTICLE_TYPE);
    }
}

