package cc.cassian.wilderflowers.registry;

import cc.cassian.wilderflowers.WilderFlowers;
import cc.cassian.wilderflowers.blocks.FlowerBedBlock;
import cc.cassian.wilderflowers.blocks.FlowerGarlandBlock;
import cc.cassian.wilderflowers.items.FlowerGarlandItem;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2498;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

import static cc.cassian.wilderflowers.registry.CommonRegistry.registerBlock;

public class WilderFlowersBlocks {
    public static ArrayList<WildflowerSupplier> WILDFLOWERS = new ArrayList<>();

    public static final WildflowerSupplier HOPEFUL_WILDFLOWERS = registerWildflowerBlock("hopeful_wildflowers");
    public static final WildflowerSupplier CHEERY_WILDFLOWERS = registerWildflowerBlock("cheery_wildflowers", true, false,
            //? if >1.21.5 {
            /*Blocks.WILDFLOWERS
            *///?} else {
            null
            //?}
    );
    public static final WildflowerSupplier MOODY_WILDFLOWERS = registerWildflowerBlock("moody_wildflowers");
    public static final WildflowerSupplier PLAYFUL_WILDFLOWERS = registerWildflowerBlock("playful_wildflowers", true, false, class_2246.field_42750);
    public static final WildflowerSupplier CLOVERS = registerWildflowerBlock("clovers", false, true, null);


    private static WildflowerSupplier registerWildflowerBlock(String id, boolean generateGarland, boolean replaceable, class_2248 flowerbed) {
        // Register flowerbed or use vanilla variant.
        Supplier<class_2248> flowerBedBlockSupplier;
        if (flowerbed == null) {
            flowerBedBlockSupplier = registerBlock(id, () -> new FlowerBedBlock(flowerBedProperties(id, replaceable)));
            CommonRegistry.registerItem(id, () -> new class_1747(flowerBedBlockSupplier.get(), blockItemProperties(id)));
        } else {
            flowerBedBlockSupplier =  ()->flowerbed;
        }

        // Register flower garland (if needed)
        Supplier<FlowerGarlandBlock> flowerGarlandBlockSupplier;
        if (generateGarland) {
            var garlandId = id.replace("flowers", "flower_garland");
            flowerGarlandBlockSupplier = registerBlock(garlandId, () -> new FlowerGarlandBlock(flowerBedProperties(garlandId, replaceable)));
            CommonRegistry.registerItem(garlandId, () -> new FlowerGarlandItem(flowerGarlandBlockSupplier.get(), blockItemProperties(garlandId)
                    //? if >1.21.2
                    /*.equippableUnswappable(EquipmentSlot.HEAD)*/
            ));
        } else {
            flowerGarlandBlockSupplier = null;
        }

        // Register flower pot.
        Supplier<class_2248> flowerPotSupplier = registerBlock("potted_" + id, () -> new class_2362(flowerBedBlockSupplier.get(), copy(class_2246.field_10495)
                //? if >1.21.2
                /*.setId(blockKey("potted_" + id))*/
        ));

        // Return wildflower block set.
        WildflowerSupplier wildflowerSupplier = new WildflowerSupplier(id, flowerBedBlockSupplier, Optional.ofNullable(flowerGarlandBlockSupplier), flowerPotSupplier);
        WilderFlowersBlocks.WILDFLOWERS.add(wildflowerSupplier);
        return wildflowerSupplier;
    }

    private static class_4970.class_2251 copy(class_2248 flowerPot) {
        //? if >1.21 {
        /*return BlockBehaviour.Properties.ofFullCopy(flowerPot);
        *///?} else {
        return class_4970.class_2251.method_9630(flowerPot);
        //?}
    }

    private static WildflowerSupplier registerWildflowerBlock(String id) {
        return registerWildflowerBlock(id, true, false, null);
    }

    static class_1792.@NotNull class_1793 blockItemProperties(String id) {
        return new class_1792.class_1793()
                //? if >1.21.2 {
                /*.useBlockDescriptionPrefix().setId(itemKey(id))
        *///?}
        ;
    }

    static class_5321<class_2248> blockKey(String id) {
        return class_5321.method_29179(class_7924.field_41254, WilderFlowers.locate(id));
    }

    static class_5321<class_1792> itemKey(String id) {
        return class_5321.method_29179(class_7924.field_41197, WilderFlowers.locate(id));
    }

    private static class_4970.class_2251 flowerBedProperties(String id, boolean replaceable) {
        var properties = class_4970.class_2251.method_9637().method_9626(class_2498.field_42772)
                //? if >1.21.2 {
                /*.setId(blockKey(id))
                *///?}
                //? if >1.21.9 {
                /*.noCollision()
                *///?} else {
                .method_9634()
                //?}
                ;
        if (replaceable) {
            properties = properties.method_51371();
        }
        return properties;
    }

    public static void touch() {

    }

    public static List<class_1799> getWildflowerItems() {
        ArrayList<class_1799> list = new ArrayList<>();
        WILDFLOWERS.forEach((wildflowerSupplier -> {
            if (wildflowerSupplier.flowerBedItem().method_40131().method_40237().
                    //? if >1.21.10 {
                    /*identifier()
                    *///?} else {
                    method_29177()
                    //?}
                    .method_12836().equals("wilderflowers")) {
                list.add(wildflowerSupplier.flowerBedItem().method_7854());
            }
            if (wildflowerSupplier.garland().isPresent())
                list.add(wildflowerSupplier.garlandItem().method_7854());
        }));
        //? if >1.21 {
        /*return list.reversed();
        *///?} else {
        return list;
        //?}

    }
}
