package cc.cassian.wilderflowers.registry;

//? if fabric
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_2400;
import java.util.function.Supplier;

public class WilderFlowersParticleTypes {

    public static final Supplier<class_2400> CHEERY_PETAL;
    public static final Supplier<class_2400> PLAYFUL_PETAL;
    public static final Supplier<class_2400> HOPEFUL_PETAL;
    public static final Supplier<class_2400> MOODY_PETAL;

    private static Supplier<class_2400> registerSimpleParticleType(boolean alwaysShow, String name) {
        return CommonRegistry.registerParticleType(name, ()->
            //? if fabric {
            FabricParticleTypes.simple(alwaysShow)
            //?} else {
            /*new SimpleParticleType(alwaysShow)
            *///?}
        );
    }

    static {
        CHEERY_PETAL = registerSimpleParticleType(true, "cheery_petal");
        PLAYFUL_PETAL = registerSimpleParticleType(true, "playful_petal");
        HOPEFUL_PETAL = registerSimpleParticleType(true, "hopeful_petal");
        MOODY_PETAL = registerSimpleParticleType(true, "moody_petal");
    }

    public static void touch() {

    }
}
