/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.events;

import cc.cassian.wilderflowers.items.FlowerGarlandItem;
import cc.cassian.wilderflowers.registry.WilderFlowersBlocks;
import cc.cassian.wilderflowers.registry.WilderFlowersParticleTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4066;
import net.minecraft.class_746;

public class FlowerGarlandEvent {
    private static final float STEP_LENGTH = 2.0f;
    private static final float PARTICLE_CHANCE = 0.25f;
    private static final float PARTICLE_CHANCE_SPRINTING = 0.75f;
    private static final float TWO_PARTICLE_CHANCE = 0.5f;
    private static final Map<UUID, class_243> prevPositions = new HashMap<UUID, class_243>();
    private static final Map<class_1792, class_2400> PARTICLES = new HashMap<class_1792, class_2400>();

    public static void tick(class_310 mc) {
        class_4066 status = (class_4066)mc.field_1690.method_42475().method_41753();
        class_746 player = mc.field_1724;
        if (status == class_4066.field_18199) {
            return;
        }
        if (player == null) {
            return;
        }
        class_1792 headItem = player.method_6118(class_1304.field_6169).method_7909();
        if (headItem instanceof FlowerGarlandItem && player.method_24828()) {
            UUID playerId = player.method_5667();
            class_243 playerPos = player.method_19538();
            if (!prevPositions.containsKey(playerId)) {
                prevPositions.put(playerId, playerPos);
                return;
            }
            class_243 prevPlayerPos = prevPositions.get(playerId);
            double distance = playerPos.method_1022(prevPlayerPos);
            if (distance > 2.0) {
                float f = player.method_6051().method_43057();
                float f2 = player.method_5624() ? 0.75f : 0.25f;
                if (f <= f2) {
                    class_243 movement = player.method_18798().method_1029().method_22882();
                    class_2400 particle = PARTICLES.get(headItem);
                    if (particle != null) {
                        int particleCount = player.method_6051().method_43057() <= 0.5f ? 1 : 2;
                        for (int i = 0; i < particleCount; ++i) {
                            player.method_37908().method_8406((class_2394)particle, playerPos.method_10216() + movement.field_1352 / 2.0, playerPos.method_10214() + 1.0 + (double)player.method_6051().method_43057() * 0.4, playerPos.method_10215() + movement.field_1350 / 2.0, 0.0, 0.0, 0.0);
                        }
                    }
                    prevPositions.put(playerId, playerPos);
                }
            }
        }
    }

    static {
        PARTICLES.put(WilderFlowersBlocks.CHEERY_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.CHEERY_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.PLAYFUL_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.PLAYFUL_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.HOPEFUL_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.HOPEFUL_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.MOODY_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.MOODY_PETAL.get());
    }
}

