package cc.cassian.wilderflowers.events;

import cc.cassian.wilderflowers.items.FlowerGarlandItem;
import cc.cassian.wilderflowers.registry.WilderFlowersBlocks;
import cc.cassian.wilderflowers.registry.WilderFlowersParticleTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4066;

public class FlowerGarlandEvent {
    private static final float STEP_LENGTH = 2.0F; // How far does the player need to move before trying to spawn another particle
    private static final float PARTICLE_CHANCE = 0.25F;
    private static final float PARTICLE_CHANCE_SPRINTING = 0.75F;
    private static final float TWO_PARTICLE_CHANCE = 0.5F;
    private static final Map<UUID, class_243> prevPositions = new HashMap<>();
    private static final Map<class_1792, class_2400> PARTICLES = new HashMap<>();

    static {
        //? <1.21.5
        /*PARTICLES.put(WilderFlowersBlocks.CHEERY_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.CHEERY_PETAL.get());*/
        //? <1.20
        /*PARTICLES.put(WilderFlowersBlocks.PLAYFUL_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.PLAYFUL_PETAL.get());*/
        PARTICLES.put(WilderFlowersBlocks.HOPEFUL_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.HOPEFUL_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.MOODY_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.MOODY_PETAL.get());
    }

    public static void tick(class_310 mc) {
        class_4066 status = mc.field_1690.method_42475().method_41753();
        var player = mc.field_1724;
        if (status == class_4066.field_18199) return;
        if (player == null) return;

        class_1792 headItem = player.method_6118(class_1304.field_6169).method_7909();
        if (headItem instanceof FlowerGarlandItem && player.method_24828()) {
            UUID playerId = player.method_5667();
            class_243 playerPos = player.method_73189();

            if (!prevPositions.containsKey(playerId)) {
                prevPositions.put(playerId, playerPos);
                return;
            }

            class_243 prevPlayerPos = prevPositions.get(playerId);
            double distance = playerPos.method_1022(prevPlayerPos);

            if (distance > STEP_LENGTH && player.method_59922().method_43057() <= (player.method_5624() ? PARTICLE_CHANCE_SPRINTING : PARTICLE_CHANCE) ) {
                class_243 movement = player.method_18798().method_1029().method_22882();
                class_2400 particle = PARTICLES.get(headItem);

                if (particle != null) {
                    int particleCount = player.method_59922().method_43057() <= TWO_PARTICLE_CHANCE ? 1 : 2;
                    for (int i = 0; i < particleCount; i++) {
                        player.method_73183().method_8406(
                                particle,
                                playerPos.method_10216() + (movement.field_1352/2),
                                playerPos.method_10214()+1 + player.method_59922().method_43057() * 0.4,
                                playerPos.method_10215() + (movement.field_1350/2),
                                0, 0, 0
                        );
                    }
                }
                prevPositions.put(playerId, playerPos);
            }
        }
    }
}