/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.poggersRituals;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PoggersRituals
extends JavaPlugin
implements TabExecutor,
Listener {
    private Ritual activeRitual = null;
    private File craftsFile;
    private FileConfiguration craftsCfg;

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupCraftsFile();
        Objects.requireNonNull(this.getCommand("ritual")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("ritualcrafts")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("deletecrafts")).setExecutor((CommandExecutor)this);
        PluginCommand main = Objects.requireNonNull(this.getCommand("poggersrituals"));
        main.setExecutor((CommandExecutor)this);
        main.setTabCompleter((TabCompleter)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("PoggersRituals enabled.");
    }

    public void onDisable() {
        if (this.activeRitual != null) {
            try {
                if (this.activeRitual.bar != null) {
                    this.activeRitual.bar.removeAll();
                }
                if (this.activeRitual.task != null) {
                    this.activeRitual.task.cancel();
                }
                if (this.activeRitual.floatingItem != null && !this.activeRitual.floatingItem.isDead()) {
                    this.activeRitual.floatingItem.remove();
                }
                try {
                    this.activeRitual.world.setChunkForceLoaded(this.activeRitual.chunkX, this.activeRitual.chunkZ, false);
                }
                catch (Throwable t) {
                    try {
                        this.activeRitual.world.getChunkAt(this.activeRitual.start).setForceLoaded(false);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.activeRitual = null;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String name = cmd.getName().toLowerCase(Locale.ROOT);
        if (name.equals("poggersrituals")) {
            if (!sender.hasPermission("poggersrituals.admin")) {
                sender.sendMessage(PoggersRituals.noPerm());
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                this.reloadCrafts();
                sender.sendMessage(PoggersRituals.color("&aPoggersRituals reloaded config and crafts.yml."));
            } else {
                sender.sendMessage(PoggersRituals.color("&eUsage: /PoggersRituals reload"));
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Players only.");
            return true;
        }
        Player p = (Player)sender;
        if (!p.hasPermission("poggersrituals.admin")) {
            p.sendMessage(PoggersRituals.noPerm());
            return true;
        }
        switch (name) {
            case "ritual": {
                if (this.activeRitual != null) {
                    p.sendMessage(PoggersRituals.color("&cA ritual is already in progress. Please wait."));
                    return true;
                }
                ItemStack hand = p.getInventory().getItemInMainHand();
                if (PoggersRituals.isAir(hand)) {
                    p.sendMessage(PoggersRituals.color("&cYou must hold an item."));
                    return true;
                }
                this.startRitual(p, hand.clone(), true);
                return true;
            }
            case "ritualcrafts": {
                ItemStack hand = p.getInventory().getItemInMainHand();
                if (PoggersRituals.isAir(hand)) {
                    p.sendMessage(PoggersRituals.color("&cHold the item you want to register."));
                    return true;
                }
                this.addCraftItem(hand.clone());
                p.sendMessage(PoggersRituals.color("&aAdded to crafts.yml: &f" + PoggersRituals.niceName(hand)));
                return true;
            }
            case "deletecrafts": {
                ItemStack hand = p.getInventory().getItemInMainHand();
                if (PoggersRituals.isAir(hand)) {
                    p.sendMessage(PoggersRituals.color("&cHold the item you want to remove."));
                    return true;
                }
                boolean removed = this.removeCraftItem(hand);
                if (removed) {
                    p.sendMessage(PoggersRituals.color("&aRemoved from crafts.yml: &f" + PoggersRituals.niceName(hand)));
                } else {
                    p.sendMessage(PoggersRituals.color("&eNo matching item found in crafts.yml."));
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (cmd.getName().equalsIgnoreCase("poggersrituals") && args.length == 1) {
            return Collections.singletonList("reload");
        }
        return Collections.emptyList();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.activeRitual != null && this.activeRitual.bar != null) {
            this.activeRitual.bar.addPlayer(e.getPlayer());
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ItemStack result;
        HumanEntity he = e.getWhoClicked();
        if (!(he instanceof Player)) {
            return;
        }
        Player p = (Player)he;
        if (this.craftsCfg == null) {
            return;
        }
        ItemStack itemStack = result = e.getRecipe() != null ? e.getRecipe().getResult() : null;
        if (PoggersRituals.isAir(result)) {
            return;
        }
        if (this.isInCrafts(result)) {
            if (this.activeRitual != null) {
                e.setCancelled(true);
                p.sendMessage(PoggersRituals.color("&cA ritual is already in progress. Crafting blocked."));
                return;
            }
            e.setCancelled(true);
            CraftingInventory ci = e.getInventory();
            ItemStack[] empty = new ItemStack[ci.getMatrix().length];
            ci.setMatrix(empty);
            ci.setResult(new ItemStack(Material.AIR));
            p.updateInventory();
            this.startRitual(p, result.clone(), false);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        if (!this.getConfig().getBoolean("cancel-on-death.enabled", false)) {
            return;
        }
        if (this.activeRitual != null && e.getEntity().getUniqueId().equals(this.activeRitual.ownerId)) {
            this.endRitual(false);
            if (this.getConfig().getBoolean("cancel-on-death.broadcast", true)) {
                String msg = PoggersRituals.color(this.getConfig().getString("cancel-on-death.message", "&c&lRitual shattered! &7<player> died.")).replace("<player>", e.getEntity().getName());
                Bukkit.getOnlinePlayers().forEach(pl -> pl.sendMessage(msg));
            }
        }
    }

    private void startRitual(Player p, ItemStack ritualItem, boolean removeFromHand) {
        Particle particle;
        if (this.activeRitual != null) {
            p.sendMessage(PoggersRituals.color("&cA ritual is already in progress. Please wait."));
            return;
        }
        int duration = Math.max(1, this.getConfig().getInt("ritual-duration-seconds", 300));
        double radius = this.getConfig().getDouble("particle.radius", 5.0);
        int columns = Math.max(6, this.getConfig().getInt("particle.columns", 12));
        double rpm = this.getConfig().getDouble("particle.rpm", 6.0);
        String particleName = this.getConfig().getString("particle.type", "SONIC_BOOM").toUpperCase(Locale.ROOT);
        double vAmp = this.getConfig().getDouble("particle.vertical.amplitude", 1.25);
        double vRpm = this.getConfig().getDouble("particle.vertical.rpm", 3.0);
        try {
            particle = Particle.valueOf((String)particleName);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warning("Invalid particle.type '" + particleName + "', falling back to SONIC_BOOM.");
            particle = Particle.SONIC_BOOM;
        }
        Particle.DustOptions dustOptions = particle == Particle.DUST ? new Particle.DustOptions(Color.fromRGB((int)PoggersRituals.clamp(this.getConfig().getInt("particle.dust.r", 0), 0, 255), (int)PoggersRituals.clamp(this.getConfig().getInt("particle.dust.g", 230), 0, 255), (int)PoggersRituals.clamp(this.getConfig().getInt("particle.dust.b", 230), 0, 255)), (float)this.getConfig().getDouble("particle.dust.size", 1.2)) : null;
        Location start = p.getLocation().getBlock().getLocation().add(0.5, 0.0, 0.5);
        World world = start.getWorld();
        if (world == null) {
            return;
        }
        int chunkX = start.getBlockX() >> 4;
        int chunkZ = start.getBlockZ() >> 4;
        try {
            world.setChunkForceLoaded(chunkX, chunkZ, true);
        }
        catch (Throwable t) {
            try {
                world.getChunkAt(start).setForceLoaded(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String itemName = ritualItem.hasItemMeta() && ritualItem.getItemMeta().hasDisplayName() ? ChatColor.stripColor((String)ritualItem.getItemMeta().getDisplayName()) : PoggersRituals.beautifyName(ritualItem.getType().name());
        String coords = String.valueOf(ChatColor.GOLD) + "(" + start.getBlockX() + ", " + start.getBlockY() + ", " + start.getBlockZ() + ")";
        String worldStyled = String.valueOf(ChatColor.DARK_PURPLE) + world.getName();
        String msg = String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + p.getName() + String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GOLD) + " has started a ritual at " + coords + String.valueOf(ChatColor.GOLD) + " in " + worldStyled + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.AQUA) + itemName;
        Bukkit.getOnlinePlayers().forEach(pl -> pl.sendMessage(msg));
        world.playSound(start, Sound.ENTITY_WARDEN_EMERGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        BossBar bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.PURPLE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bar.setVisible(true);
        Collection online = Bukkit.getOnlinePlayers();
        online.forEach(arg_0 -> ((BossBar)bar).addPlayer(arg_0));
        if (removeFromHand) {
            p.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        }
        Location itemLoc = start.clone().add(0.0, 3.0, 0.0);
        Item floatingItem = world.dropItem(itemLoc, ritualItem.clone());
        floatingItem.setGravity(false);
        floatingItem.setPickupDelay(Integer.MAX_VALUE);
        floatingItem.setInvulnerable(true);
        floatingItem.setUnlimitedLifetime(true);
        floatingItem.setGlowing(true);
        ItemStack ritualStack = ritualItem.clone();
        ritualStack.setAmount(1);
        this.activeRitual = new Ritual(p.getUniqueId(), start, world, itemName, bar, floatingItem, particle, dustOptions, radius, columns, rpm, duration, vAmp, vRpm, ritualStack, chunkX, chunkZ);
        this.activeRitual.startTask(this);
    }

    private void endRitual(boolean success) {
        if (this.activeRitual == null || this.activeRitual.ended) {
            return;
        }
        Ritual r = this.activeRitual;
        r.ended = true;
        try {
            r.world.setChunkForceLoaded(r.chunkX, r.chunkZ, false);
        }
        catch (Throwable t) {
            try {
                r.world.getChunkAt(r.start).setForceLoaded(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (success) {
            if (r.floatingItem != null && r.floatingItem.isValid() && !r.floatingItem.isDead()) {
                r.floatingItem.setGravity(true);
                r.floatingItem.setPickupDelay(0);
                r.floatingItem.setInvulnerable(false);
                r.floatingItem.setGlowing(false);
            } else {
                r.world.dropItemNaturally(r.start.clone().add(0.5, 1.0, 0.5), r.ritualStack.clone());
            }
            r.world.playSound(r.start, Sound.ENTITY_ENDER_DRAGON_GROWL, SoundCategory.PLAYERS, 1.0f, 1.0f);
        } else {
            Sound s;
            if (r.floatingItem != null && !r.floatingItem.isDead()) {
                r.floatingItem.remove();
            }
            String soundName = this.getConfig().getString("cancel-on-death.sound", "BLOCK_GLASS_BREAK").toUpperCase(Locale.ROOT);
            try {
                s = Sound.valueOf((String)soundName);
            }
            catch (IllegalArgumentException ex) {
                s = Sound.BLOCK_GLASS_BREAK;
            }
            r.world.playSound(r.start, s, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (r.bar != null) {
            r.bar.removeAll();
        }
        if (r.task != null) {
            r.task.cancel();
        }
        this.activeRitual = null;
    }

    private void setupCraftsFile() {
        this.craftsFile = new File(this.getDataFolder(), "crafts.yml");
        if (!this.craftsFile.exists()) {
            try {
                this.getDataFolder().mkdirs();
                this.craftsFile.createNewFile();
                this.craftsCfg = YamlConfiguration.loadConfiguration((File)this.craftsFile);
                this.craftsCfg.set("crafts", new ArrayList());
                this.craftsCfg.save(this.craftsFile);
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create crafts.yml: " + e.getMessage());
            }
        } else {
            this.craftsCfg = YamlConfiguration.loadConfiguration((File)this.craftsFile);
            if (!this.craftsCfg.isSet("crafts")) {
                this.craftsCfg.set("crafts", new ArrayList());
            }
        }
    }

    private void reloadCrafts() {
        this.craftsCfg = YamlConfiguration.loadConfiguration((File)this.craftsFile);
        if (!this.craftsCfg.isSet("crafts")) {
            this.craftsCfg.set("crafts", new ArrayList());
        }
    }

    private void saveCrafts() {
        try {
            this.craftsCfg.save(this.craftsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save crafts.yml: " + e.getMessage());
        }
    }

    private List<ItemStack> getCraftItems() {
        return this.craftsCfg.getList("crafts", new ArrayList());
    }

    private void setCraftItems(List<ItemStack> items) {
        this.craftsCfg.set("crafts", items);
        this.saveCrafts();
    }

    private void addCraftItem(ItemStack stack) {
        List<ItemStack> items = this.getCraftItems();
        items.add(PoggersRituals.normalizeAmount(stack.clone()));
        this.setCraftItems(items);
    }

    private boolean removeCraftItem(ItemStack stack) {
        ItemStack target;
        List<ItemStack> items = this.getCraftItems();
        boolean removed = items.removeIf(arg_0 -> PoggersRituals.lambda$removeCraftItem$2(target = PoggersRituals.normalizeAmount(stack.clone()), arg_0));
        if (removed) {
            this.setCraftItems(items);
        }
        return removed;
    }

    private boolean isInCrafts(ItemStack result) {
        ItemStack target = PoggersRituals.normalizeAmount(result.clone());
        for (ItemStack s : this.getCraftItems()) {
            if (!PoggersRituals.isSimilarOrSameType(s, target)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack normalizeAmount(ItemStack s) {
        s.setAmount(1);
        return s;
    }

    private static boolean isSimilarOrSameType(ItemStack a, ItemStack b) {
        boolean metaB;
        boolean metaA = a.hasItemMeta() && a.getItemMeta() != null && (a.getItemMeta().hasDisplayName() || a.getItemMeta().hasLore() || a.getItemMeta().hasCustomModelData());
        boolean bl = metaB = b.hasItemMeta() && b.getItemMeta() != null && (b.getItemMeta().hasDisplayName() || b.getItemMeta().hasLore() || b.getItemMeta().hasCustomModelData());
        if (!metaA && !metaB) {
            return a.getType() == b.getType();
        }
        return a.isSimilar(b);
    }

    private static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(s == null ? "" : s));
    }

    private static String noPerm() {
        return String.valueOf(ChatColor.RED) + "You don't have permission.";
    }

    private static boolean isAir(ItemStack s) {
        return s == null || s.getType() == Material.AIR;
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    private static String beautifyName(String enumName) {
        return Arrays.stream(enumName.toLowerCase(Locale.ROOT).split("_")).map(t -> t.substring(0, 1).toUpperCase(Locale.ROOT) + t.substring(1)).collect(Collectors.joining(" "));
    }

    private static String niceName(ItemStack s) {
        return s.hasItemMeta() && s.getItemMeta().hasDisplayName() ? ChatColor.stripColor((String)s.getItemMeta().getDisplayName()) : PoggersRituals.beautifyName(s.getType().name());
    }

    private static String formatTime(int seconds) {
        int m = seconds / 60;
        int s = seconds % 60;
        return new DecimalFormat("00").format(m) + ":" + new DecimalFormat("00").format(s);
    }

    private static /* synthetic */ boolean lambda$removeCraftItem$2(ItemStack target, ItemStack s) {
        return PoggersRituals.isSimilarOrSameType(s, target);
    }

    private final class Ritual {
        final UUID ownerId;
        final Location start;
        final World world;
        final String itemName;
        final BossBar bar;
        Particle particle;
        Particle.DustOptions dustOptions;
        double radius;
        int columns;
        double rpm;
        long totalTicks;
        double vAmp;
        double vRpm;
        Item floatingItem;
        final ItemStack ritualStack;
        final int chunkX;
        final int chunkZ;
        BukkitRunnable task;
        boolean ended = false;

        Ritual(UUID ownerId, Location start, World world, String itemName, BossBar bar, Item floatingItem, Particle particle, Particle.DustOptions dustOptions, double radius, int columns, double rpm, int seconds, double vAmp, double vRpm, ItemStack ritualStack, int chunkX, int chunkZ) {
            this.ownerId = ownerId;
            this.start = start.clone();
            this.world = world;
            this.itemName = itemName;
            this.bar = bar;
            this.floatingItem = floatingItem;
            this.particle = particle;
            this.dustOptions = dustOptions;
            this.radius = radius;
            this.columns = columns;
            this.rpm = rpm;
            this.totalTicks = (long)seconds * 20L;
            this.vAmp = vAmp;
            this.vRpm = vRpm;
            this.ritualStack = ritualStack.clone();
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        void startTask(JavaPlugin plugin) {
            final long startMs = System.currentTimeMillis();
            this.task = new BukkitRunnable(){
                double base = 0.0;

                public void run() {
                    long elapsedTicks = (System.currentTimeMillis() - startMs) / 50L;
                    if (Ritual.this.floatingItem == null || !Ritual.this.floatingItem.isValid() || Ritual.this.floatingItem.isDead()) {
                        Location itemLoc = Ritual.this.start.clone().add(0.0, 3.0, 0.0);
                        Ritual.this.floatingItem = Ritual.this.world.dropItem(itemLoc, Ritual.this.ritualStack.clone());
                        Ritual.this.floatingItem.setGravity(false);
                        Ritual.this.floatingItem.setPickupDelay(Integer.MAX_VALUE);
                        Ritual.this.floatingItem.setInvulnerable(true);
                        Ritual.this.floatingItem.setUnlimitedLifetime(true);
                        Ritual.this.floatingItem.setGlowing(true);
                    } else {
                        Ritual.this.floatingItem.teleport(Ritual.this.start.clone().add(0.0, 3.0, 0.0));
                    }
                    if (elapsedTicks >= Ritual.this.totalTicks) {
                        PoggersRituals.this.endRitual(true);
                        return;
                    }
                    double progress = 1.0 - (double)elapsedTicks / (double)Ritual.this.totalTicks;
                    String mmss = PoggersRituals.formatTime((int)Math.ceil((double)(Ritual.this.totalTicks - elapsedTicks) / 20.0));
                    Ritual.this.bar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                    Ritual.this.bar.setTitle(String.valueOf(ChatColor.LIGHT_PURPLE) + Ritual.this.itemName + String.valueOf(ChatColor.GRAY) + " : " + String.valueOf(ChatColor.WHITE) + "(" + Ritual.this.start.getBlockX() + ", " + Ritual.this.start.getBlockY() + ", " + Ritual.this.start.getBlockZ() + ") " + String.valueOf(ChatColor.DARK_GRAY) + " [" + mmss + "]");
                    double radiansPerTick = Ritual.this.rpm * 2.0 * Math.PI / 1200.0;
                    this.base += radiansPerTick;
                    double tSeconds = (double)elapsedTicks / 20.0;
                    double yOffset = 0.4 + Ritual.this.vAmp * Math.sin(Math.PI * 2 * (Ritual.this.vRpm / 60.0) * tSeconds);
                    for (int i = 0; i < Ritual.this.columns; ++i) {
                        double angle = this.base + Math.PI * 2 * (double)i / (double)Ritual.this.columns;
                        double x = Math.cos(angle) * Ritual.this.radius;
                        double z = Math.sin(angle) * Ritual.this.radius;
                        Location spot = Ritual.this.start.clone().add(x, yOffset, z);
                        if (Ritual.this.particle == Particle.SONIC_BOOM) {
                            double ox = Math.cos(angle) * 0.6;
                            double oy = 0.02;
                            double oz = Math.sin(angle) * 0.6;
                            Ritual.this.world.spawnParticle(Particle.SONIC_BOOM, spot, 0, ox, oy, oz, 0.0);
                            continue;
                        }
                        if (Ritual.this.particle == Particle.DUST && Ritual.this.dustOptions != null) {
                            Ritual.this.world.spawnParticle(Particle.DUST, spot, 0, 0.0, 0.0, 0.0, 0.0, (Object)Ritual.this.dustOptions, true);
                            continue;
                        }
                        Ritual.this.world.spawnParticle(Ritual.this.particle, spot, 6, 0.05, 0.05, 0.05, 0.0);
                    }
                }
            };
            this.task.runTaskTimer((Plugin)plugin, 0L, 1L);
        }
    }
}

