/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger;

import com.daqem.grieflogger.config.GriefLoggerConfig;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.event.ChatEvent;
import com.daqem.grieflogger.event.CommandEvent;
import com.daqem.grieflogger.event.EntityEvents;
import com.daqem.grieflogger.event.LevelLoadEvent;
import com.daqem.grieflogger.event.PlayerJoinEvent;
import com.daqem.grieflogger.event.PlayerQuitEvent;
import com.daqem.grieflogger.event.RegisterCommandEvent;
import com.daqem.grieflogger.event.TickEvents;
import com.daqem.grieflogger.event.block.BlockEvents;
import com.daqem.grieflogger.event.item.ItemEvents;
import com.mojang.logging.LogUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class GriefLogger {
    public static final String MOD_ID = "grieflogger";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static Database DATABASE;

    public static void init() {
        GriefLogger.initConfigs();
        boolean databaseReady = GriefLogger.prepareDatabase();
        if (!databaseReady) {
            return;
        }
        GriefLogger.registerEvents();
    }

    private static void initConfigs() {
        GriefLoggerConfig.init();
    }

    private static void registerEvents() {
        BlockEvents.registerEvents();
        TickEvents.registerEvents();
        EntityEvents.registerEvents();
        ItemEvents.registerEvents();
        PlayerJoinEvent.registerEvent();
        PlayerQuitEvent.registerEvent();
        LevelLoadEvent.registerEvent();
        RegisterCommandEvent.registerEvent();
        ChatEvent.registerEvent();
        CommandEvent.registerEvent();
    }

    private static boolean prepareDatabase() {
        LOGGER.info("Preparing GriefLogger database...");
        long start = System.currentTimeMillis();
        try {
            DATABASE = new Database();
            boolean connected = DATABASE.createConnection();
            if (!connected) {
                LOGGER.error("Failed to connect to database, disabling GriefLogger...");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to connect to database, disabling GriefLogger...", (Throwable)e);
            return false;
        }
        Services.MATERIAL.createTable();
        Services.USER.createTable();
        Services.USERNAME.createTable();
        Services.LEVEL.createTable();
        Services.ENTITY.createTable();
        Services.BLOCK.createTable();
        Services.CONTAINER.createTable();
        Services.SESSION.createTable();
        Services.CHAT.createTable();
        Services.COMMAND.createTable();
        Services.ITEM.createTable();
        if (((Boolean)GriefLoggerConfig.useIndexes.get()).booleanValue()) {
            Services.BLOCK.createIndexes();
            Services.CHAT.createIndexes();
            Services.COMMAND.createIndexes();
            Services.CONTAINER.createIndexes();
            Services.ITEM.createIndexes();
            Services.SESSION.createIndexes();
        }
        long end = System.currentTimeMillis();
        LOGGER.info("Database prepared in {}ms.", (Object)(end - start));
        return true;
    }

    public static Database getDatabase() {
        return DATABASE;
    }

    public static MutableComponent translate(String str) {
        MutableComponent component = GriefLogger.translate(str, TranslatableContents.NO_ARGS);
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = Component.literal((String)component.getString()).withStyle(component.getStyle());
        }
        return component;
    }

    public static MutableComponent translate(String str, Object ... args) {
        MutableComponent component = Component.translatable((String)("grieflogger." + str), (Object[])args);
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = Component.literal((String)component.getString()).withStyle(component.getStyle());
        }
        return component;
    }

    public static MutableComponent literal(String str) {
        return Component.literal((String)str);
    }

    public static MutableComponent themedTranslate(String str) {
        MutableComponent component = GriefLogger.themedTranslate(str, TranslatableContents.NO_ARGS);
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = Component.literal((String)component.getString()).withStyle(component.getStyle());
        }
        return component;
    }

    public static MutableComponent themedTranslate(String str, Object ... args) {
        MutableComponent component = Component.translatable((String)("grieflogger." + str), (Object[])args).withStyle(GriefLogger.getTheme());
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = Component.literal((String)component.getString()).withStyle(component.getStyle());
        }
        return component;
    }

    public static MutableComponent themedLiteral(String str) {
        MutableComponent component = Component.literal((String)str).withStyle(GriefLogger.getTheme());
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = Component.literal((String)component.getString()).withStyle(component.getStyle());
        }
        return component;
    }

    public static Component getName() {
        MutableComponent component = GriefLogger.translate("name").withStyle(GriefLogger.getTheme());
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = Component.literal((String)component.getString()).withStyle(component.getStyle());
        }
        return component;
    }

    public static Style getTheme() {
        return Style.EMPTY.withColor(16562691);
    }

    public static ResourceLocation getId(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }
}

