/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.block.container;

import com.daqem.grieflogger.block.container.IContainerTransactionManager;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;

public class ContainerTransactionManager
implements IContainerTransactionManager {
    private final BaseContainerBlockEntity blockEntity;
    private final List<SimpleItemStack> initialItems = new ArrayList<SimpleItemStack>();
    private final List<SimpleItemStack> finalItems = new ArrayList<SimpleItemStack>();

    public ContainerTransactionManager(BaseContainerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
            this.addItem(blockEntity.getItem(i), this.initialItems);
        }
    }

    @Override
    public void finalize(ServerPlayer serverPlayer) {
        this.constructFinalItems();
        List<SimpleItemStack> removedItems = this.getRemovedItems();
        List<SimpleItemStack> addedItems = this.getAddedItems();
        Services.CONTAINER.insertMap(serverPlayer.getUUID(), (Level)(this.blockEntity.getLevel() != null ? this.blockEntity.getLevel() : serverPlayer.level()), this.blockEntity.getBlockPos(), Map.of(ItemAction.REMOVE_ITEM, removedItems, ItemAction.ADD_ITEM, addedItems));
    }

    private void constructFinalItems() {
        for (int i = 0; i < this.blockEntity.getContainerSize(); ++i) {
            this.addItem(this.blockEntity.getItem(i), this.finalItems);
        }
    }

    private List<SimpleItemStack> getRemovedItems() {
        return new ArrayList<SimpleItemStack>(this.getDifference(this.initialItems, this.finalItems));
    }

    private List<SimpleItemStack> getDifference(List<SimpleItemStack> x, List<SimpleItemStack> y) {
        ArrayList<SimpleItemStack> difference = new ArrayList<SimpleItemStack>();
        for (SimpleItemStack xItem : x) {
            y.stream().filter(xItem::equals).findFirst().ifPresentOrElse(yItem -> {
                if (yItem.getCount() < xItem.getCount()) {
                    difference.add(new SimpleItemStack(xItem.getItem(), xItem.getCount() - yItem.getCount(), xItem.getTag()));
                }
            }, () -> difference.add(xItem));
        }
        return difference;
    }

    private List<SimpleItemStack> getAddedItems() {
        return new ArrayList<SimpleItemStack>(this.getDifference(this.finalItems, this.initialItems));
    }

    private void addItem(ItemStack itemStack, List<SimpleItemStack> itemStackList) {
        if (itemStack.getItem().equals(Items.AIR)) {
            return;
        }
        if (itemStack.getCount() == 0) {
            return;
        }
        for (SimpleItemStack simpleItemStack : itemStackList) {
            if (simpleItemStack.getItem() != itemStack.getItem()) continue;
            if (simpleItemStack.hasTag() && !itemStack.getComponentsPatch().isEmpty() && simpleItemStack.getTag().equals((Object)itemStack.getComponentsPatch())) {
                simpleItemStack.addCount(itemStack.getCount());
                return;
            }
            if (!simpleItemStack.hasNoTag() || !itemStack.getComponentsPatch().isEmpty()) continue;
            simpleItemStack.addCount(itemStack.getCount());
            return;
        }
        itemStackList.add(new SimpleItemStack(itemStack));
    }
}

