/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.block.container;

import com.daqem.grieflogger.block.container.IContainerTransactionManager;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;

public class ContainersTransactionManager
implements IContainerTransactionManager {
    private final List<BaseContainerBlockEntity> blockEntities;
    private final Map<BaseContainerBlockEntity, List<SimpleItemStack>> initialItems = new HashMap<BaseContainerBlockEntity, List<SimpleItemStack>>();
    private final Map<BaseContainerBlockEntity, List<SimpleItemStack>> finalItems = new HashMap<BaseContainerBlockEntity, List<SimpleItemStack>>();

    public ContainersTransactionManager(List<BaseContainerBlockEntity> blockEntities) {
        this.blockEntities = blockEntities;
        for (BaseContainerBlockEntity blockEntity : blockEntities) {
            this.initialItems.put(blockEntity, new ArrayList());
            this.finalItems.put(blockEntity, new ArrayList());
            for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                this.addItem(blockEntity.getItem(i), this.initialItems.get(blockEntity));
            }
        }
    }

    @Override
    public void finalize(ServerPlayer serverPlayer) {
        for (BaseContainerBlockEntity blockEntity : this.blockEntities) {
            this.constructFinalItems(blockEntity);
            List<SimpleItemStack> removedItems = this.getRemovedItems(blockEntity);
            List<SimpleItemStack> addedItems = this.getAddedItems(blockEntity);
            Services.CONTAINER.insertMap(serverPlayer.getUUID(), (Level)(blockEntity.getLevel() != null ? blockEntity.getLevel() : serverPlayer.level()), blockEntity.getBlockPos(), Map.of(ItemAction.REMOVE_ITEM, removedItems, ItemAction.ADD_ITEM, addedItems));
        }
    }

    private void constructFinalItems(BaseContainerBlockEntity blockEntity) {
        for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
            this.addItem(blockEntity.getItem(i), this.finalItems.get(blockEntity));
        }
    }

    private List<SimpleItemStack> getRemovedItems(BaseContainerBlockEntity blockEntity) {
        return new ArrayList<SimpleItemStack>(this.getDifference(this.initialItems.get(blockEntity), this.finalItems.get(blockEntity)));
    }

    private List<SimpleItemStack> getDifference(List<SimpleItemStack> x, List<SimpleItemStack> y) {
        ArrayList<SimpleItemStack> difference = new ArrayList<SimpleItemStack>();
        for (SimpleItemStack xItem : x) {
            y.stream().filter(xItem::equals).findFirst().ifPresentOrElse(yItem -> {
                if (yItem.getCount() < xItem.getCount()) {
                    difference.add(new SimpleItemStack(xItem.getItem(), xItem.getCount() - yItem.getCount(), xItem.getTag()));
                }
            }, () -> difference.add(xItem));
        }
        return difference;
    }

    private List<SimpleItemStack> getAddedItems(BaseContainerBlockEntity blockEntity) {
        return new ArrayList<SimpleItemStack>(this.getDifference(this.finalItems.get(blockEntity), this.initialItems.get(blockEntity)));
    }

    private void addItem(ItemStack itemStack, List<SimpleItemStack> itemStackList) {
        if (itemStack.getItem().equals(Items.AIR)) {
            return;
        }
        if (itemStack.getCount() == 0) {
            return;
        }
        for (SimpleItemStack simpleItemStack : itemStackList) {
            if (simpleItemStack.getItem() != itemStack.getItem()) continue;
            if (simpleItemStack.hasTag() && !itemStack.getComponentsPatch().isEmpty() && simpleItemStack.getTag().equals((Object)itemStack.getComponentsPatch())) {
                simpleItemStack.addCount(itemStack.getCount());
                return;
            }
            if (!simpleItemStack.hasNoTag() || !itemStack.getComponentsPatch().isEmpty()) continue;
            simpleItemStack.addCount(itemStack.getCount());
            return;
        }
        itemStackList.add(new SimpleItemStack(itemStack));
    }
}

