/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.ICommand;
import com.daqem.grieflogger.command.argument.FilterArgument;
import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.command.page.Page;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.model.history.IHistory;
import com.daqem.grieflogger.model.history.ItemHistory;
import com.daqem.grieflogger.model.history.SessionHistory;
import com.daqem.grieflogger.player.GriefLoggerServerPlayer;
import com.daqem.grieflogger.thread.ThreadManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class LookupCommand
implements ICommand {
    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lookup").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"filter1", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"filter2", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"filter3", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"filter4", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(Commands.argument((String)"filter5", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).executes(context -> LookupCommand.lookup((CommandSourceStack)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2"), FilterArgument.getFilter(context, "filter3"), FilterArgument.getFilter(context, "filter4"), FilterArgument.getFilter(context, "filter5")), (CommandSourceStack)context.getSource()))))).executes(context -> LookupCommand.lookup((CommandSourceStack)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2"), FilterArgument.getFilter(context, "filter3"), FilterArgument.getFilter(context, "filter4")), (CommandSourceStack)context.getSource()))))).executes(context -> LookupCommand.lookup((CommandSourceStack)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2"), FilterArgument.getFilter(context, "filter3")), (CommandSourceStack)context.getSource()))))).executes(context -> LookupCommand.lookup((CommandSourceStack)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2")), (CommandSourceStack)context.getSource()))))).executes(context -> LookupCommand.lookup((CommandSourceStack)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1")), (CommandSourceStack)context.getSource()))));
    }

    private static int lookup(CommandSourceStack source, FilterList filterList) {
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer instanceof GriefLoggerServerPlayer) {
            GriefLoggerServerPlayer player = (GriefLoggerServerPlayer)serverPlayer;
            ThreadManager.submit(() -> LookupCommand.getHistory((Level)source.getLevel(), filterList), filteredHistory -> {
                if (filteredHistory.isEmpty()) {
                    source.sendFailure((Component)GriefLogger.translate("lookup.no_results", GriefLogger.getName()));
                    return;
                }
                List<Page> pages = Page.convertToPages(filteredHistory, false);
                player.grieflogger$setPages(pages);
                Page pageToDisplay = pages.get(0);
                pageToDisplay.sendToPlayer((ServerPlayer)player);
            });
        }
        return 1;
    }

    private static List<IHistory> getHistory(Level level, FilterList filterList) {
        List<SessionHistory> filteredSessionHistory = Services.SESSION.getFilteredSessionHistory(level, filterList);
        List<IHistory> filteredBlockHistory = Services.BLOCK.getFilteredBlockHistory(level, filterList);
        List<IHistory> filteredContainerHistory = Services.CONTAINER.getFilteredContainerHistory(level, filterList);
        List<ItemHistory> filteredItemHistory = Services.ITEM.getFilteredItemHistory(level, filterList);
        return new ArrayList<List<ItemHistory>>(List.of(filteredSessionHistory, filteredBlockHistory, filteredContainerHistory, filteredItemHistory)).stream().flatMap(Collection::stream).sorted((x, y) -> Long.compare(y.getTime().time(), x.getTime().time())).collect(Collectors.toList());
    }
}

