/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.filter;

import com.daqem.grieflogger.command.filter.IFilter;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.extensions.injected.InjectedRegistryEntryExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;

public abstract class ItemFilter
implements IFilter {
    private final List<Item> items;

    public ItemFilter() {
        this(new ArrayList<Item>());
    }

    public ItemFilter(List<Item> items) {
        this.items = items;
    }

    @Override
    public List<String> getOptions() {
        return new ArrayList<String>(BuiltInRegistries.ITEM.stream().map(x -> x.arch$registryName().toString().replace("minecraft:", "")).toList());
    }

    protected List<Item> getItemsFromSuffix(StringReader reader, String suffix) throws CommandSyntaxException {
        List<Item> items;
        String[] split = suffix.split(",");
        if (split.length != (items = BuiltInRegistries.ITEM.stream().filter(item -> Arrays.asList(split).contains(item.arch$registryName().toString().replace("minecraft:", ""))).toList()).size()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
        }
        return items;
    }

    public String toString() {
        return "ItemFilter{items=" + String.valueOf(this.items.stream().map(InjectedRegistryEntryExtension::arch$registryName).toList()) + "}";
    }

    public List<String> getMaterials() {
        return this.items.stream().map(InjectedRegistryEntryExtension::arch$registryName).filter(Objects::nonNull).map(Object::toString).map(x -> x.replace("minecraft:", "")).toList();
    }
}

