/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.service;

import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.ContainerRepository;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.IHistory;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ContainerService {
    private final ContainerRepository containerRepository;

    public ContainerService(Database database) {
        this.containerRepository = new ContainerRepository(database);
    }

    public void createTable() {
        this.containerRepository.createTable();
    }

    public void createIndexes() {
        this.containerRepository.createIndexes();
    }

    public void insert(UUID userUuid, Level level, BlockPos pos, SimpleItemStack item, ItemAction itemAction) {
        ResourceLocation itemLocation = item.getItem().arch$registryName();
        if (itemLocation != null) {
            this.containerRepository.insert(System.currentTimeMillis(), userUuid.toString(), level, pos.getX(), pos.getY(), pos.getZ(), item, itemAction.getId());
        }
    }

    public void insertList(UUID userUuid, Level level, BlockPos pos, List<SimpleItemStack> items, ItemAction itemAction) {
        this.containerRepository.insertList(System.currentTimeMillis(), userUuid.toString(), level, pos.getX(), pos.getY(), pos.getZ(), items, itemAction.getId());
    }

    public void insertMap(UUID userUuid, Level level, BlockPos pos, Map<ItemAction, List<SimpleItemStack>> itemsMap) {
        this.containerRepository.insertMap(System.currentTimeMillis(), userUuid.toString(), level, pos.getX(), pos.getY(), pos.getZ(), itemsMap);
    }

    public List<IHistory> getHistory(Level level, BlockPos pos) {
        return this.containerRepository.getHistory(level, pos.getX(), pos.getY(), pos.getZ());
    }

    public List<IHistory> getHistory(Level level, BlockPos pos, BlockPos connectionPos) {
        return this.containerRepository.getHistory(level, pos.getX(), pos.getY(), pos.getZ(), connectionPos.getX(), connectionPos.getY(), connectionPos.getZ());
    }

    public List<IHistory> getFilteredContainerHistory(Level level, FilterList filterList) {
        return this.containerRepository.getFilteredContainerHistory(level, filterList);
    }
}

