/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.event;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.config.GriefLoggerConfig;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.thread.ThreadManager;
import dev.architectury.event.events.common.TickEvent;
import java.util.concurrent.ExecutionException;

public class TickEvents {
    private static long lastTick = 0L;

    public static void registerEvents() {
        TickEvent.SERVER_POST.register(server -> {
            ThreadManager.getAndRemoveCompleted().forEach((future, onComplete) -> {
                try {
                    onComplete.onComplete(future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    GriefLogger.LOGGER.error("Error executing task", (Throwable)e);
                }
            });
            if (lastTick % (long)((Integer)GriefLoggerConfig.queueFrequency.get()).intValue() == 0L) {
                ThreadManager.execute(() -> {
                    Database database = GriefLogger.getDatabase();
                    database.queue.execute();
                    database.batchQueue.execute();
                });
            }
            if (lastTick % (long)((Integer)GriefLoggerConfig.helloFrequency.get()).intValue() == 0L) {
                ThreadManager.execute(() -> {
                    Database database = GriefLogger.getDatabase();
                    database.queue.hello();
                });
            }
            ++lastTick;
        });
    }
}

