/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.event.block;

import com.daqem.grieflogger.block.BlockHandler;
import com.daqem.grieflogger.block.container.ContainerHandler;
import com.daqem.grieflogger.event.AbstractEvent;
import com.daqem.grieflogger.event.block.InspectBlockEvent;
import com.daqem.grieflogger.event.block.InspectContainerEvent;
import com.daqem.grieflogger.event.block.InspectDoorEvent;
import com.daqem.grieflogger.event.block.LogBlockEvent;
import com.daqem.grieflogger.model.action.BlockAction;
import com.daqem.grieflogger.player.GriefLoggerServerPlayer;
import dev.architectury.event.EventResult;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class RightClickBlockEvent
extends AbstractEvent {
    public static EventResult rightClickBlock(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player instanceof GriefLoggerServerPlayer) {
            GriefLoggerServerPlayer serverPlayer = (GriefLoggerServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND) {
                Level level = player.level();
                BlockState state = level.getBlockState(pos);
                Block block = state.getBlock();
                if (serverPlayer.grieflogger$isInspecting()) {
                    BlockEntity blockEntity;
                    Optional<BaseContainerBlockEntity> container;
                    if (state.getBlock() instanceof DoorBlock) {
                        return InspectDoorEvent.inspectDoor(serverPlayer, level, pos, state, true);
                    }
                    if (state.hasBlockEntity() && (container = ContainerHandler.getContainer(blockEntity = level.getBlockEntity(pos))).isPresent()) {
                        ChestType chestType;
                        if (state.hasProperty((Property)ChestBlock.TYPE) && (chestType = (ChestType)state.getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE) {
                            Direction connectionDirection = (Direction)state.getValue((Property)ChestBlock.FACING);
                            BlockPos connectionPos = pos;
                            if (chestType == ChestType.LEFT) {
                                connectionPos = connectionDirection == Direction.NORTH ? pos.east() : (connectionDirection == Direction.SOUTH ? pos.west() : (connectionDirection == Direction.WEST ? pos.north() : pos.south()));
                            }
                            if (chestType == ChestType.RIGHT) {
                                connectionPos = connectionDirection == Direction.NORTH ? pos.west() : (connectionDirection == Direction.SOUTH ? pos.east() : (connectionDirection == Direction.WEST ? pos.south() : pos.north()));
                            }
                            return InspectContainerEvent.inspectContainers(serverPlayer, level, pos, connectionPos);
                        }
                        return InspectContainerEvent.inspectContainer(serverPlayer, level, pos);
                    }
                    return InspectBlockEvent.inspectBlock(serverPlayer, pos.relative(direction));
                }
                if (BlockHandler.isBlockIntractable(block)) {
                    LogBlockEvent.logBlock(serverPlayer, level, state, pos, BlockAction.INTERACT_BLOCK);
                }
            }
        }
        return RightClickBlockEvent.pass();
    }
}

