/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.mixin;

import com.daqem.grieflogger.event.item.BreakItemEvent;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public class MixinItemStack {
    @Inject(at={@At(value="HEAD")}, method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V"})
    private void hurtAndBreak(int i, ServerLevel serverLevel, ServerPlayer serverPlayer, Consumer<Item> consumer, CallbackInfo ci) {
        ItemStack itemStack = (ItemStack)this;
        if (itemStack.isDamageableItem() && (serverPlayer == null || !serverPlayer.hasInfiniteMaterials())) {
            int j;
            if (i > 0 && (i = EnchantmentHelper.processDurabilityChange((ServerLevel)serverLevel, (ItemStack)itemStack, (int)i)) <= 0) {
                return;
            }
            if (serverPlayer != null && i != 0) {
                CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(serverPlayer, itemStack, itemStack.getDamageValue() + i);
            }
            if ((j = itemStack.getDamageValue() + i) >= itemStack.getMaxDamage()) {
                BreakItemEvent.breakItem((Player)serverPlayer, itemStack.copyWithCount(1));
            }
        }
    }
}

