/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.ICommand;
import com.daqem.grieflogger.command.argument.FilterArgument;
import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.command.page.Page;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.model.history.IHistory;
import com.daqem.grieflogger.model.history.ItemHistory;
import com.daqem.grieflogger.model.history.SessionHistory;
import com.daqem.grieflogger.player.GriefLoggerServerPlayer;
import com.daqem.grieflogger.thread.ThreadManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class LookupCommand
implements ICommand {
    @Override
    public LiteralArgumentBuilder<class_2168> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lookup").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"filter1", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"filter2", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"filter3", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"filter4", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).then(class_2170.method_9244((String)"filter5", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> new FilterArgument().listSuggestions(context, builder)).executes(context -> LookupCommand.lookup((class_2168)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2"), FilterArgument.getFilter(context, "filter3"), FilterArgument.getFilter(context, "filter4"), FilterArgument.getFilter(context, "filter5")), (class_2168)context.getSource()))))).executes(context -> LookupCommand.lookup((class_2168)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2"), FilterArgument.getFilter(context, "filter3"), FilterArgument.getFilter(context, "filter4")), (class_2168)context.getSource()))))).executes(context -> LookupCommand.lookup((class_2168)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2"), FilterArgument.getFilter(context, "filter3")), (class_2168)context.getSource()))))).executes(context -> LookupCommand.lookup((class_2168)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1"), FilterArgument.getFilter(context, "filter2")), (class_2168)context.getSource()))))).executes(context -> LookupCommand.lookup((class_2168)context.getSource(), new FilterList(List.of(FilterArgument.getFilter(context, "filter1")), (class_2168)context.getSource()))));
    }

    private static int lookup(class_2168 source, FilterList filterList) {
        class_3222 class_32222 = source.method_44023();
        if (class_32222 instanceof GriefLoggerServerPlayer) {
            GriefLoggerServerPlayer player = (GriefLoggerServerPlayer)class_32222;
            ThreadManager.submit(() -> LookupCommand.getHistory((class_1937)source.method_9225(), filterList), filteredHistory -> {
                if (filteredHistory.isEmpty()) {
                    source.method_9213((class_2561)GriefLogger.translate("lookup.no_results", GriefLogger.getName()));
                    return;
                }
                List<Page> pages = Page.convertToPages(filteredHistory, false);
                player.grieflogger$setPages(pages);
                Page pageToDisplay = pages.get(0);
                pageToDisplay.sendToPlayer((class_3222)player);
            });
        }
        return 1;
    }

    private static List<IHistory> getHistory(class_1937 level, FilterList filterList) {
        List<SessionHistory> filteredSessionHistory = Services.SESSION.getFilteredSessionHistory(level, filterList);
        List<IHistory> filteredBlockHistory = Services.BLOCK.getFilteredBlockHistory(level, filterList);
        List<IHistory> filteredContainerHistory = Services.CONTAINER.getFilteredContainerHistory(level, filterList);
        List<ItemHistory> filteredItemHistory = Services.ITEM.getFilteredItemHistory(level, filterList);
        return new ArrayList<List<ItemHistory>>(List.of(filteredSessionHistory, filteredBlockHistory, filteredContainerHistory, filteredItemHistory)).stream().flatMap(Collection::stream).sorted((x, y) -> Long.compare(y.getTime().time(), x.getTime().time())).collect(Collectors.toList());
    }
}

