/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.filter;

import com.daqem.grieflogger.command.filter.ActionFilter;
import com.daqem.grieflogger.command.filter.ExcludeFilter;
import com.daqem.grieflogger.command.filter.IFilter;
import com.daqem.grieflogger.command.filter.IncludeFilter;
import com.daqem.grieflogger.command.filter.RadiusFilter;
import com.daqem.grieflogger.command.filter.TimeFilter;
import com.daqem.grieflogger.command.filter.UserFilter;
import com.daqem.grieflogger.model.BlockPosition;
import com.daqem.grieflogger.model.action.IAction;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;

public class FilterList {
    @Nullable
    private ActionFilter actionFilter;
    @Nullable
    private ExcludeFilter excludeFilter;
    @Nullable
    private IncludeFilter includeFilter;
    @Nullable
    private RadiusFilter radiusFilter;
    @Nullable
    private TimeFilter timeFilter;
    @Nullable
    private UserFilter userFilter;

    public FilterList(List<IFilter> filters, class_2168 source) {
        Map filterMap = filters.stream().collect(Collectors.toMap((Function<IFilter, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lcom/daqem/grieflogger/command/filter/IFilter;)Ljava/lang/Class;)(), Function.identity(), (a, b) -> b));
        this.actionFilter = (ActionFilter)filterMap.get(ActionFilter.class);
        this.excludeFilter = (ExcludeFilter)filterMap.get(ExcludeFilter.class);
        this.includeFilter = (IncludeFilter)filterMap.get(IncludeFilter.class);
        this.radiusFilter = (RadiusFilter)filterMap.get(RadiusFilter.class);
        this.timeFilter = (TimeFilter)filterMap.get(TimeFilter.class);
        this.userFilter = (UserFilter)filterMap.get(UserFilter.class);
        if (this.radiusFilter != null) {
            this.radiusFilter.setPosition(new BlockPosition((int)source.method_9222().method_10216(), (int)source.method_9222().method_10214(), (int)source.method_9222().method_10215()));
        }
    }

    public Optional<ActionFilter> getActionFilter() {
        return Optional.ofNullable(this.actionFilter);
    }

    @Nullable
    public String getActionString() {
        return this.getActionFilter().map(x -> x.getActions().stream().map(IAction::getId).map(String::valueOf).collect(Collectors.joining(","))).orElse(null);
    }

    public void setActionFilter(@Nullable ActionFilter actionFilter) {
        this.actionFilter = actionFilter;
    }

    public Optional<ExcludeFilter> getExcludeFilter() {
        return Optional.ofNullable(this.excludeFilter);
    }

    @Nullable
    public String getExcludeMaterialsString() {
        return this.getExcludeFilter().map(x -> x.getMaterials().stream().map(String::valueOf).collect(Collectors.joining("','"))).orElse(null);
    }

    public void setExcludeFilter(@Nullable ExcludeFilter excludeFilter) {
        this.excludeFilter = excludeFilter;
    }

    public Optional<IncludeFilter> getIncludeFilter() {
        return Optional.ofNullable(this.includeFilter);
    }

    @Nullable
    public String getIncludeMaterialsString() {
        return this.getIncludeFilter().map(x -> x.getMaterials().stream().map(String::valueOf).collect(Collectors.joining("','"))).orElse(null);
    }

    public void setIncludeFilter(@Nullable IncludeFilter includeFilter) {
        this.includeFilter = includeFilter;
    }

    public Optional<RadiusFilter> getRadiusFilter() {
        return Optional.ofNullable(this.radiusFilter);
    }

    public int getRadiusMinX() {
        return this.getRadiusFilter().map(RadiusFilter::getMinX).orElse(0);
    }

    public int getRadiusMaxX() {
        return this.getRadiusFilter().map(RadiusFilter::getMaxX).orElse(0);
    }

    public int getRadiusMinY() {
        return this.getRadiusFilter().map(RadiusFilter::getMinY).orElse(0);
    }

    public int getRadiusMaxY() {
        return this.getRadiusFilter().map(RadiusFilter::getMaxY).orElse(0);
    }

    public int getRadiusMinZ() {
        return this.getRadiusFilter().map(RadiusFilter::getMinZ).orElse(0);
    }

    public int getRadiusMaxZ() {
        return this.getRadiusFilter().map(RadiusFilter::getMaxZ).orElse(0);
    }

    public void setRadiusFilter(@Nullable RadiusFilter radiusFilter) {
        this.radiusFilter = radiusFilter;
    }

    public Optional<TimeFilter> getTimeFilter() {
        return Optional.ofNullable(this.timeFilter);
    }

    public long getTime() {
        return this.getTimeFilter().map(TimeFilter::getTime).orElse(0L);
    }

    public void setTimeFilter(@Nullable TimeFilter timeFilter) {
        this.timeFilter = timeFilter;
    }

    public Optional<UserFilter> getUserFilter() {
        return Optional.ofNullable(this.userFilter);
    }

    @Nullable
    public String getUserString() {
        return this.getUserFilter().map(x -> x.getUserIds().stream().map(String::valueOf).collect(Collectors.joining(","))).orElse(null);
    }

    public void setUserFilter(@Nullable UserFilter userFilter) {
        this.userFilter = userFilter;
    }
}

