/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.filter;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.IFilter;
import com.daqem.grieflogger.model.BlockPosition;
import com.mojang.brigadier.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RadiusFilter
implements IFilter {
    private final int radius;
    private BlockPosition position = new BlockPosition(0, 0, 0);

    public RadiusFilter() {
        this(0);
    }

    public RadiusFilter(int radius) {
        this.radius = radius;
    }

    @Override
    public String getName() {
        return GriefLogger.translate("filter.radius").getString();
    }

    @Override
    public List<String> getOptions() {
        return IntStream.rangeClosed(1, 100).mapToObj(Integer::toString).collect(Collectors.toList());
    }

    @Override
    public IFilter parse(StringReader reader, String suffix) {
        return new RadiusFilter(Integer.parseInt(suffix));
    }

    public String toString() {
        return "RadiusFilter{radius=" + this.radius + "}";
    }

    public int getMinX() {
        return this.position.x() - this.radius;
    }

    public int getMaxX() {
        return this.position.x() + this.radius;
    }

    public int getMinY() {
        return this.position.y() - this.radius;
    }

    public int getMaxY() {
        return this.position.y() + this.radius;
    }

    public int getMinZ() {
        return this.position.z() - this.radius;
    }

    public int getMaxZ() {
        return this.position.z() + this.radius;
    }

    public void setPosition(BlockPosition position) {
        this.position = position;
    }
}

