/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class UserRepository
extends Repository {
    private final Database database;

    public UserRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS users (\n\tid integer PRIMARY KEY,\n\tname text NOT NULL,\n\tuuid text DEFAULT NULL UNIQUE\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS users (\n\tid int PRIMARY KEY AUTO_INCREMENT,\n\tname varchar(16) NOT NULL,\n\tuuid varchar(36) DEFAULT NULL UNIQUE\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void insertOrUpdateName(String name, String uuid) {
        String query = "INSERT INTO users(name, uuid)\nVALUES(?, ?)\nON CONFLICT(uuid)\nDO UPDATE SET name = ?\n";
        if (this.isMysql()) {
            query = "INSERT INTO users(name, uuid)\nVALUES(?, ?)\nON DUPLICATE KEY UPDATE name = ?\n";
        }
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setString(1, name);
            preparedStatement.setString(2, uuid);
            preparedStatement.setString(3, name);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert username into database", (Throwable)exception);
        }
    }

    public void insertNonPlayer(String name) {
        String query = "INSERT INTO users(name)\nVALUES('%s')\nON CONFLICT(name)\nDO NOTHING\n";
        if (this.isMysql()) {
            query = "INSERT INTO users(name)\nVALUES('%s')\nON DUPLICATE KEY UPDATE name = name\n";
        }
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setString(1, name);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert username into database", (Throwable)exception);
        }
    }

    public Map<Integer, String> getAllUsernames() {
        HashMap<Integer, String> usernames = new HashMap<Integer, String>();
        String query = "SELECT id, name FROM users\n";
        try (PreparedStatement preparedStatement = this.database.prepareStatement(query);){
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                usernames.put(resultSet.getInt(1), resultSet.getString(2));
            }
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to get all usernames from database", (Throwable)exception);
        }
        return usernames;
    }
}

