/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.service;

import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.BlockRepository;
import com.daqem.grieflogger.model.action.BlockAction;
import com.daqem.grieflogger.model.history.IHistory;
import com.daqem.grieflogger.thread.OnComplete;
import com.daqem.grieflogger.thread.ThreadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class BlockService {
    private final BlockRepository blockRepository;

    public BlockService(Database database) {
        this.blockRepository = new BlockRepository(database);
    }

    public void createTable() {
        this.blockRepository.createTable();
    }

    public void createIndexes() {
        this.blockRepository.createIndexes();
    }

    public void insertMaterial(UUID userUuid, String levelName, BlockPos pos, String material, BlockAction blockAction) {
        material = material.replace("minecraft:", "");
        this.blockRepository.insertMaterial(System.currentTimeMillis(), userUuid.toString(), levelName, pos.getX(), pos.getY(), pos.getZ(), material, blockAction.getId());
    }

    public void insertEntity(UUID userUuid, String levelName, BlockPos pos, String entity, BlockAction blockAction) {
        entity = entity.replace("minecraft:", "");
        this.blockRepository.insertEntity(System.currentTimeMillis(), userUuid.toString(), levelName, pos.getX(), pos.getY(), pos.getZ(), entity, blockAction.getId());
    }

    public List<IHistory> getBlockHistory(Level level, BlockPos pos) {
        return this.blockRepository.getBlockHistory(level.dimension().location().toString(), pos.getX(), pos.getY(), pos.getZ());
    }

    public void getBlockHistoryAsync(Level level, BlockPos pos, OnComplete<List<IHistory>> onComplete) {
        ThreadManager.submit(() -> this.getBlockHistory(level, pos), onComplete);
    }

    public List<IHistory> getBlockHistory(Level level, List<BlockPos> pos) {
        ArrayList<IHistory> blockHistories = new ArrayList<IHistory>();
        for (BlockPos blockPos : pos) {
            blockHistories.addAll(this.getBlockHistory(level, blockPos));
        }
        return blockHistories.stream().sorted((o1, o2) -> (int)(o2.getTime().time() - o1.getTime().time())).toList();
    }

    public void getBlockHistoryAsync(Level level, List<BlockPos> pos, OnComplete<List<IHistory>> onComplete) {
        ThreadManager.submit(() -> this.getBlockHistory(level, pos), onComplete);
    }

    public List<IHistory> getInteractionHistory(Level level, BlockPos pos) {
        return this.blockRepository.getInteractionHistory(level.dimension().location().toString(), pos.getX(), pos.getY(), pos.getZ());
    }

    public List<IHistory> getInteractionHistory(Level level, List<BlockPos> pos) {
        ArrayList<IHistory> blockHistories = new ArrayList<IHistory>();
        for (BlockPos blockPos : pos) {
            blockHistories.addAll(this.getInteractionHistory(level, blockPos));
        }
        return blockHistories.stream().sorted((o1, o2) -> (int)(o2.getTime().time() - o1.getTime().time())).toList();
    }

    public void getInteractionHistoryAsync(Level level, List<BlockPos> pos, OnComplete<List<IHistory>> onComplete) {
        ThreadManager.submit(() -> this.getInteractionHistory(level, pos), onComplete);
    }

    public void removeInteractionsForPosition(Level level, BlockPos secondPos) {
        this.blockRepository.removeInteractionsForPosition(level.dimension().location().toString(), secondPos.getX(), secondPos.getY(), secondPos.getZ());
    }

    public List<IHistory> getFilteredBlockHistory(Level level, FilterList filterList) {
        return this.blockRepository.getFilteredBlockHistory(level.dimension().location().toString(), filterList);
    }
}

