/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.service;

import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.ItemRepository;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.ItemHistory;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ItemService {
    private final ItemRepository itemRepository;

    public ItemService(Database database) {
        this.itemRepository = new ItemRepository(database);
    }

    public void createTable() {
        this.itemRepository.createTable();
    }

    public void createIndexes() {
        this.itemRepository.createIndexes();
    }

    public void insert(UUID userUuid, Level level, BlockPos pos, SimpleItemStack item, ItemAction itemAction) {
        ResourceLocation itemLocation = item.getItem().arch$registryName();
        if (itemLocation != null) {
            this.itemRepository.insert(System.currentTimeMillis(), userUuid.toString(), level, pos.getX(), pos.getY(), pos.getZ(), item, itemAction.getId());
        }
    }

    public void insertMap(UUID userUuid, Level level, BlockPos pos, Map<ItemAction, List<SimpleItemStack>> itemsMap) {
        this.itemRepository.insertMap(System.currentTimeMillis(), userUuid.toString(), level, pos.getX(), pos.getY(), pos.getZ(), itemsMap);
    }

    public List<ItemHistory> getFilteredItemHistory(Level level, FilterList filterList) {
        return this.itemRepository.getFilteredItemHistory(level, filterList);
    }
}

