/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.model;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SimpleItemStack {
    private final Item item;
    private int count;
    private final DataComponentPatch tag;

    public SimpleItemStack(ItemStack itemStack) {
        this(itemStack.getItem(), itemStack.getCount(), itemStack.getComponentsPatch());
    }

    public SimpleItemStack(ResourceLocation itemLocation, int count, DataComponentPatch tag) {
        this.item = (Item)BuiltInRegistries.ITEM.getValue(itemLocation);
        this.count = count;
        this.tag = tag;
    }

    public SimpleItemStack(Item item, int count, DataComponentPatch tag) {
        this.item = item;
        this.count = count;
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleItemStack that = (SimpleItemStack)o;
        return Objects.equals(this.item, that.item) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.count, this.tag);
    }

    public Item getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public DataComponentPatch getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public boolean hasNoTag() {
        return this.tag == null;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void addCount(int count) {
        this.count += count;
    }

    public byte @Nullable [] getTagBytes(Level level) {
        if (this.tag == null) {
            return null;
        }
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), level.registryAccess());
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)this.tag);
        byte[] temp = new byte[buf.readableBytes()];
        buf.readBytes(temp);
        return temp;
    }

    public ItemStack toItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.item, this.count);
        itemStack.applyComponents(this.tag);
        return itemStack;
    }

    public boolean isEmpty() {
        return this.item.equals(ItemStack.EMPTY.getItem()) || this.count == 0;
    }
}

