/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.model.history;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.model.BlockPosition;
import com.daqem.grieflogger.model.Time;
import com.daqem.grieflogger.model.User;
import com.daqem.grieflogger.model.action.BlockAction;
import com.daqem.grieflogger.model.history.History;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class BlockHistory
extends History {
    private final String material;

    public BlockHistory(long time, String name, String uuid, int x, int y, int z, String material, int blockAction) {
        this(new Time(time), new User(name, UUID.fromString(uuid)), new BlockPosition(x, y, z), material, BlockAction.fromId(blockAction));
    }

    public BlockHistory(Time time, User user, BlockPosition position, String material, BlockAction action) {
        super(time, user, position, action);
        this.material = material;
    }

    @Override
    public Component getComponent() {
        return this.getTime().getFormattedTimeAgo().append(" ").append(this.getAction().getPrefix()).append(" ").append(this.getUser().getNameComponent()).append(" ").append(this.getAction().getPastTense()).append(" ").append(this.getMaterialComponent());
    }

    @Override
    public Component getMaterialComponent() {
        Holder.Reference blockReference = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.material)).orElse(null);
        Item item = blockReference != null ? ((Block)blockReference.value()).asItem() : Items.AIR;
        MutableComponent mutableComponent = GriefLogger.themedLiteral(this.material.replace("minecraft:", ""));
        if (item != Items.AIR) {
            return mutableComponent.withStyle(mutableComponent.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(item.getDefaultInstance()))));
        }
        return mutableComponent.withStyle(mutableComponent.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)this.material))));
    }
}

